/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.resource.list;

import com.refinedmods.refinedstorage.api.core.CoreValidations;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.list.MutableResourceList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="2.0.0-milestone.1.2")
public class MutableResourceListImpl
implements MutableResourceList {
    private final Map<ResourceKey, Entry> entries;

    private MutableResourceListImpl(Map<ResourceKey, Entry> entries) {
        this.entries = entries;
    }

    public static MutableResourceListImpl create() {
        return new MutableResourceListImpl(new HashMap<ResourceKey, Entry>());
    }

    private static MutableResourceListImpl createCopy(Map<ResourceKey, Entry> entries) {
        HashMap<ResourceKey, Entry> newEntries = HashMap.newHashMap(entries.size());
        entries.forEach((key, entry) -> newEntries.put((ResourceKey)key, new Entry((ResourceKey)key, entry.amount)));
        return new MutableResourceListImpl(newEntries);
    }

    public static MutableResourceListImpl orderPreserving() {
        return new MutableResourceListImpl(new LinkedHashMap<ResourceKey, Entry>());
    }

    @Override
    public MutableResourceList.OperationResult add(ResourceKey resource, long amount) {
        ResourceAmount.validate(resource, amount);
        Entry existing = this.entries.get(resource);
        if (existing != null) {
            return this.addToExisting(existing, amount);
        }
        return this.addNew(resource, amount);
    }

    private MutableResourceList.OperationResult addToExisting(Entry entry, long amount) {
        entry.increment(amount);
        return new MutableResourceList.OperationResult(entry.resource, entry.amount, amount, true);
    }

    private MutableResourceList.OperationResult addNew(ResourceKey resource, long amount) {
        Entry entry = new Entry(resource, amount);
        this.entries.put(resource, entry);
        return new MutableResourceList.OperationResult(resource, amount, amount, true);
    }

    @Override
    @Nullable
    public MutableResourceList.OperationResult remove(ResourceKey resource, long amount) {
        ResourceAmount.validate(resource, amount);
        Entry existing = this.entries.get(resource);
        if (existing != null) {
            if (existing.amount - amount <= 0L) {
                return this.removeCompletely(existing);
            }
            return this.removePartly(amount, existing);
        }
        return null;
    }

    private MutableResourceList.OperationResult removePartly(long amount, Entry entry) {
        entry.decrement(amount);
        return new MutableResourceList.OperationResult(entry.resource, entry.amount, -amount, true);
    }

    private MutableResourceList.OperationResult removeCompletely(Entry entry) {
        this.entries.remove(entry.resource);
        return new MutableResourceList.OperationResult(entry.resource, 0L, -entry.amount, false);
    }

    @Override
    public Collection<ResourceAmount> copyState() {
        return this.entries.values().stream().map(Entry::toResourceAmount).toList();
    }

    @Override
    public Set<ResourceKey> getAll() {
        return this.entries.keySet();
    }

    @Override
    public long get(ResourceKey resource) {
        Entry entry = this.entries.get(resource);
        return entry != null ? entry.amount : 0L;
    }

    @Override
    public boolean contains(ResourceKey resource) {
        return this.entries.containsKey(resource);
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public void clear() {
        this.entries.clear();
    }

    @Override
    public MutableResourceList copy() {
        return MutableResourceListImpl.createCopy(this.entries);
    }

    public String toString() {
        return this.entries.toString();
    }

    private static class Entry {
        private final ResourceKey resource;
        private long amount;

        private Entry(ResourceKey resource, long amount) {
            this.resource = resource;
            this.amount = amount;
        }

        private void increment(long amountToIncrement) {
            CoreValidations.validateLargerThanZero(amountToIncrement, "Amount to increment must be larger than 0");
            this.amount += amountToIncrement;
        }

        private void decrement(long amountToDecrement) {
            CoreValidations.validateLargerThanZero(amountToDecrement, "Amount to decrement must be larger than 0");
            CoreValidations.validateLargerThanZero(this.amount - amountToDecrement, "Cannot decrement, amount will be zero or negative");
            this.amount -= amountToDecrement;
        }

        private ResourceAmount toResourceAmount() {
            return new ResourceAmount(this.resource, this.amount);
        }

        public String toString() {
            return String.valueOf(this.amount);
        }
    }
}

