/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items.charm;

import artifacts.registry.ModItems;
import be.florens.expandability.api.EventResult;
import be.florens.expandability.api.forge.PlayerSwimEvent;
import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.octostudios.rarcompat.network.packets.FlamingoSwimPacket;
import it.hurts.sskirillss.relics.init.DataComponentRegistry;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootEntries;
import it.hurts.sskirillss.relics.items.relics.base.data.research.ResearchData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.common.NeoForgeMod;
import top.theillusivec4.curios.api.SlotContext;

public class HeliumFlamingoItem
extends WearableRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"flying").stat(StatData.builder((String)"time").initialValue(3.0, 5.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.2).formatValue(value -> MathUtils.round((double)value, (int)1)).build()).stat(StatData.builder((String)"speed").initialValue(0.2, 0.3).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.2).formatValue(value -> (int)MathUtils.round((double)(value * 100.0), (int)1)).build()).research(ResearchData.builder().star(0, 2, 6).star(1, 8, 10).star(2, 6, 19).star(3, 15, 21).star(4, 20, 11).link(0, 2).link(1, 2).link(2, 3).link(3, 4).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-754286).borderBottom(-4967837).build()).beams(BeamsData.builder().startColor(-219985).endColor(11809379).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(10).step(100).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"flying").initialValue(1).gem(GemShape.SQUARE, GemColor.PURPLE).build()).build()).build()).loot(LootData.builder().entry(new LootEntry[]{LootEntries.AQUATIC, LootEntries.THE_END, LootEntries.END_LIKE}).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player;
        block8: {
            block7: {
                LivingEntity livingEntity = slotContext.entity();
                if (!(livingEntity instanceof Player)) break block7;
                player = (Player)livingEntity;
                if (this.isAbilityUnlocked(stack, "flying")) break block8;
            }
            return;
        }
        if (player.getCommandSenderWorld().isClientSide() && HeliumFlamingoClientEvent.onDoubleJump && ++HeliumFlamingoClientEvent.ticKCount % 10 == 0) {
            HeliumFlamingoClientEvent.onDoubleJump = false;
            HeliumFlamingoClientEvent.ticKCount = 0;
        }
        if (player.onGround() || player.isInLiquid()) {
            this.setTime(stack, 0);
        }
        if (player.tickCount % 20 == 0 && this.getToggled(stack)) {
            this.addTime(stack, 1);
            this.spreadRelicExperience((LivingEntity)player, stack, 1);
        }
        if (this.getTime(stack) >= (int)MathUtils.round((double)this.getStatValue(stack, "flying", "time"), (int)0) && !player.isInLiquid()) {
            player.setDeltaMovement(player.getDeltaMovement().x, -0.25, player.getKnownMovement().z);
            player.fallDistance = 0.0f;
            this.setToggled(stack, false);
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        Player player;
        block3: {
            block2: {
                LivingEntity livingEntity = slotContext.entity();
                if (!(livingEntity instanceof Player)) break block2;
                player = (Player)livingEntity;
                if (newStack != stack) break block3;
            }
            return;
        }
        EntityUtils.removeAttribute((LivingEntity)player, (ItemStack)stack, (Holder)NeoForgeMod.SWIM_SPEED, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        this.setToggled(stack, false);
        this.setTime(stack, 0);
    }

    public boolean getToggled(ItemStack stack) {
        return (Boolean)stack.getOrDefault((Supplier)DataComponentRegistry.TOGGLED, (Object)false);
    }

    public void setToggled(ItemStack stack, boolean val) {
        stack.set((Supplier)DataComponentRegistry.TOGGLED, (Object)val);
    }

    public void addTime(ItemStack stack, int time) {
        this.setTime(stack, this.getTime(stack) + time);
    }

    public int getTime(ItemStack stack) {
        return (Integer)stack.getOrDefault((Supplier)DataComponentRegistry.TIME, (Object)0);
    }

    public void setTime(ItemStack stack, int val) {
        stack.set((Supplier)DataComponentRegistry.TIME, (Object)Math.max(val, 0));
    }

    @EventBusSubscriber(value={Dist.CLIENT})
    public static class HeliumFlamingoClientEvent {
        private static boolean onDoubleJump = false;
        private static int ticKCount;

        @SubscribeEvent
        public static void onClientTick(InputEvent.Key event) {
            HeliumFlamingoItem relic;
            Item item;
            Minecraft minecraft = Minecraft.getInstance();
            LocalPlayer player = minecraft.player;
            if (player == null) {
                return;
            }
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.HELIUM_FLAMINGO.value()));
            if (minecraft.screen != null || event.getAction() != 1 || !((item = stack.getItem()) instanceof HeliumFlamingoItem) || !(relic = (HeliumFlamingoItem)item).canPlayerUseAbility((Player)player, stack, "flying") || event.getKey() != minecraft.options.keyJump.getKey().getValue()) {
                return;
            }
            if (!onDoubleJump) {
                onDoubleJump = true;
            } else if (!player.mayFly()) {
                int statValue = (int)MathUtils.round((double)relic.getStatValue(stack, "flying", "time"), (int)0);
                int time = relic.getTime(stack);
                if (time >= statValue) {
                    return;
                }
                NetworkHandler.sendToServer((CustomPacketPayload)new FlamingoSwimPacket(!relic.getToggled(stack)));
                if (!relic.getToggled(stack) && !player.isInLiquid()) {
                    player.setDeltaMovement(player.getDeltaMovement().add(player.getLookAngle().scale((double)0.6f)));
                }
            } else if (relic.getToggled(stack)) {
                NetworkHandler.sendToServer((CustomPacketPayload)new FlamingoSwimPacket(false));
            }
        }
    }

    @EventBusSubscriber
    public static class HeliumFlamingoEvent {
        @SubscribeEvent
        public static void onSwimAir(PlayerSwimEvent event) {
            HeliumFlamingoItem relic;
            Player player = event.getEntity();
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.HELIUM_FLAMINGO.value()));
            Item item = stack.getItem();
            if (!(item instanceof HeliumFlamingoItem) || !(relic = (HeliumFlamingoItem)item).isAbilityUnlocked(stack, "flying")) {
                return;
            }
            if (relic.getToggled(stack)) {
                event.setResult(EventResult.SUCCESS);
                player.setSprinting(true);
                EntityUtils.applyAttribute((LivingEntity)player, (ItemStack)stack, (Holder)NeoForgeMod.SWIM_SPEED, (float)((float)relic.getStatValue(stack, "flying", "speed")), (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            } else {
                event.setResult(EventResult.PASS);
                EntityUtils.removeAttribute((LivingEntity)player, (ItemStack)stack, (Holder)NeoForgeMod.SWIM_SPEED, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            }
        }
    }
}

