/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.pipegoggles.render;

import com.davenonymous.pipegoggles.config.Client;
import com.davenonymous.pipegoggles.lib.gui.GUIHelper;
import com.davenonymous.pipegoggles.lib.gui.event.MouseClickEvent;
import com.davenonymous.pipegoggles.lib.gui.event.WidgetEventResult;
import com.davenonymous.pipegoggles.lib.gui.tooltip.StringTooltipComponent;
import com.davenonymous.pipegoggles.lib.gui.tooltip.WrappedStringTooltipComponent;
import com.davenonymous.pipegoggles.lib.gui.widgets.WidgetGhostSlot;
import com.davenonymous.pipegoggles.networking.RemoveStackForColorPacket;
import com.davenonymous.pipegoggles.networking.SetEnabledForColorPacket;
import com.davenonymous.pipegoggles.networking.SetStackForColorPacket;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.language.IModInfo;

public class WidgetColoredGhostSlot
extends WidgetGhostSlot {
    private int colorA;
    private DyeColor dyeColor;

    public WidgetColoredGhostSlot(DyeColor color) {
        super(ItemStack.EMPTY, true);
        this.setSize(18, 18);
        this.colorA = GUIHelper.brighten(color.getTextColor(), 1.1f);
        this.dyeColor = color;
        this.removeEventListeners(MouseClickEvent.class);
        this.addListener(MouseClickEvent.class, (event, widget) -> {
            if (event.button == 1) {
                this.setValue(ItemStack.EMPTY);
                PacketDistributor.sendToServer((CustomPacketPayload)new RemoveStackForColorPacket(color), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.updateTooltips();
                return WidgetEventResult.HANDLED;
            }
            if (event.button != 0) {
                return WidgetEventResult.CONTINUE_PROCESSING;
            }
            ItemStack playerStack = this.getGUI().getContainer().getCarried();
            if (playerStack.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)playerStack, (ItemStack)((ItemStack)this.getValue()))) {
                if (this.grayOut()) {
                    this.setGrayOut(false);
                    PacketDistributor.sendToServer((CustomPacketPayload)new SetEnabledForColorPacket(color, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
                } else {
                    this.setGrayOut(true);
                    PacketDistributor.sendToServer((CustomPacketPayload)new SetEnabledForColorPacket(color, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            } else {
                ItemStack newStack = playerStack.copy();
                newStack.setCount(1);
                if (this.isValidItemStack(newStack)) {
                    this.setValue(newStack);
                    this.setGrayOut(false);
                    PacketDistributor.sendToServer((CustomPacketPayload)new SetStackForColorPacket(color, newStack), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    PacketDistributor.sendToServer((CustomPacketPayload)new SetEnabledForColorPacket(color, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
            this.updateTooltips();
            return WidgetEventResult.HANDLED;
        });
        this.updateTooltips();
    }

    public void updateTooltips() {
        if (this.dyeColor == null) {
            return;
        }
        ItemStack stack = (ItemStack)this.getValue();
        String dyeColorName = I18n.get((String)("item.minecraft.firework_star." + this.dyeColor.getName()), (Object[])new Object[0]);
        this.setTooltipElements(new StringTooltipComponent(dyeColorName, this.dyeColor == DyeColor.BLACK ? DyeColor.WHITE.getTextColor() : this.dyeColor.getTextColor()));
        if (!stack.isEmpty()) {
            String modName = stack.getItem().getCreatorModId(stack);
            IModFileInfo modFile = ModList.get().getModFileById(modName);
            if (modFile == null) {
                this.addTooltipElement(StringTooltipComponent.gray(I18n.get((String)stack.getDescriptionId(), (Object[])new Object[0])));
            } else if (!modFile.getMods().isEmpty()) {
                this.addTooltipElement(StringTooltipComponent.white(((IModInfo)modFile.getMods().getFirst()).getDisplayName()));
            }
        }
        if (this.getValue() != null && !((ItemStack)this.getValue()).isEmpty()) {
            if (!this.grayOut()) {
                this.addTooltipElement(StringTooltipComponent.orange(I18n.get((String)"pipegoggles.message.click_to_disable", (Object[])new Object[0])));
            } else {
                this.addTooltipElement(StringTooltipComponent.green(I18n.get((String)"pipegoggles.message.click_to_enable", (Object[])new Object[0])));
            }
            this.addTooltipElement(StringTooltipComponent.chat(I18n.get((String)"pipegoggles.message.right_click_to_remove", (Object[])new Object[0]), ChatFormatting.RED));
        } else if (Client.showHelpTooltips) {
            this.addTooltipElement(WrappedStringTooltipComponent.gray(I18n.get((String)"pipegoggles.help.insert_items", (Object[])new Object[0])));
        }
    }

    @Override
    public void setValue(ItemStack stack) {
        super.setValue(stack);
        this.updateTooltips();
    }

    @Override
    protected void drawSlot(GuiGraphics pGuiGraphics, Screen screen) {
        GUIHelper.setShaderColor(this.colorA);
        super.drawSlot(pGuiGraphics, screen);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

