/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.pipegoggles.lib.gui.widgets;

import com.davenonymous.pipegoggles.lib.gui.GUIHelper;
import com.davenonymous.pipegoggles.lib.gui.widgets.WidgetWithValue;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class WidgetBlockInClientLevel
extends WidgetWithValue<BlockPos> {
    boolean drawSlot = false;

    public WidgetBlockInClientLevel(BlockPos pos) {
        this.setSize(16, 16);
        this.setValue(pos);
    }

    public WidgetBlockInClientLevel setDrawSlot(boolean drawSlot) {
        this.drawSlot = drawSlot;
        return this;
    }

    @Override
    public void setValue(BlockPos newValue) {
        super.setValue(newValue);
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null || !level.isLoaded((BlockPos)this.getValue())) {
            return;
        }
        BlockState targetState = level.getBlockState((BlockPos)this.getValue());
        if (targetState.isAir()) {
            return;
        }
        BlockHitResult fakeHitResult = new BlockHitResult(targetState.getShape((BlockGetter)level, (BlockPos)this.getValue()).bounds().getCenter(), Direction.DOWN, (BlockPos)this.getValue(), true);
        ItemStack stack = targetState.getCloneItemStack((HitResult)fakeHitResult, (LevelReader)level, (BlockPos)this.getValue(), (Player)Minecraft.getInstance().player);
        if (!stack.isEmpty()) {
            TooltipFlag.Default tooltipFlag = Minecraft.getInstance().options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL;
            this.setTooltipLines(stack.getTooltipLines(Item.TooltipContext.EMPTY, (Player)Minecraft.getInstance().player, (TooltipFlag)tooltipFlag));
        }
    }

    private void drawSlot(GuiGraphics pGuiGraphics, Screen screen) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUIHelper.tabIcons);
        int texOffsetY = 84;
        int texOffsetX = 84;
        pGuiGraphics.blit(GUIHelper.tabIcons, -1, -1, texOffsetX, texOffsetY, 18, 18);
    }

    @Override
    public void draw(GuiGraphics pGuiGraphics, Screen screen) {
        super.draw(pGuiGraphics, screen);
        if (this.drawSlot) {
            pGuiGraphics.pose().pushPose();
            pGuiGraphics.pose().translate(0.0f, 0.0f, 50.0f);
            this.drawSlot(pGuiGraphics, screen);
            pGuiGraphics.pose().popPose();
        }
        if (this.value == null) {
            return;
        }
        if (!this.visible || !this.areAllParentsVisible()) {
            return;
        }
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null || !level.isLoaded((BlockPos)this.getValue())) {
            return;
        }
        BlockState targetState = level.getBlockState((BlockPos)this.getValue());
        if (targetState.isAir()) {
            return;
        }
        float scaleFactor = 9.0f;
        BlockRenderDispatcher blockRenderer = Minecraft.getInstance().getBlockRenderer();
        pGuiGraphics.pose().pushPose();
        pGuiGraphics.pose().translate((float)this.width / 8.0f, (float)this.height / 1.4f, 100.0f);
        pGuiGraphics.pose().scale(-scaleFactor, scaleFactor, scaleFactor);
        pGuiGraphics.pose().mulPose(Axis.XP.rotationDegrees(-30.0f));
        pGuiGraphics.pose().mulPose(Axis.YP.rotationDegrees(-45.0f));
        pGuiGraphics.pose().mulPose(Axis.ZP.rotationDegrees(180.0f));
        blockRenderer.renderSingleBlock(targetState, pGuiGraphics.pose(), (MultiBufferSource)pGuiGraphics.bufferSource(), 0xFF00F0, OverlayTexture.NO_OVERLAY, level.getModelData((BlockPos)this.value), RenderType.CUTOUT);
        pGuiGraphics.pose().popPose();
    }
}

