/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.pipegoggles.lib.gui;

import com.davenonymous.pipegoggles.lib.gui.GUI;
import com.davenonymous.pipegoggles.lib.gui.WidgetContainer;
import com.davenonymous.pipegoggles.lib.gui.WidgetSlot;
import com.davenonymous.pipegoggles.lib.gui.event.CharTypedEvent;
import com.davenonymous.pipegoggles.lib.gui.event.GuiDataUpdatedEvent;
import com.davenonymous.pipegoggles.lib.gui.event.KeyPressedEvent;
import com.davenonymous.pipegoggles.lib.gui.event.KeyReleasedEvent;
import com.davenonymous.pipegoggles.lib.gui.event.MouseClickEvent;
import com.davenonymous.pipegoggles.lib.gui.event.MouseDraggedEvent;
import com.davenonymous.pipegoggles.lib.gui.event.MouseMoveEvent;
import com.davenonymous.pipegoggles.lib.gui.event.MouseReleasedEvent;
import com.davenonymous.pipegoggles.lib.gui.event.MouseScrollEvent;
import com.davenonymous.pipegoggles.lib.gui.event.UpdateScreenEvent;
import com.davenonymous.pipegoggles.lib.gui.event.WidgetEventResult;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;

public abstract class WidgetContainerScreen<T extends WidgetContainer>
extends AbstractContainerScreen<T> {
    protected GUI gui;
    private int previousMouseX = Integer.MAX_VALUE;
    private int previousMouseY = Integer.MAX_VALUE;
    public boolean dataUpdated = false;
    public boolean renderTitle = true;
    public boolean renderInventoryTitle = true;
    public Component customTitle = null;

    public WidgetContainerScreen(T container, Inventory inv, Component name) {
        super(container, inv, name);
        this.gui = this.createGUI();
        this.gui.setVisible(true);
        this.imageWidth = this.gui.width;
        this.imageHeight = this.gui.height;
    }

    public WidgetContainerScreen<T> setCustomTitle(Component customTitle) {
        this.customTitle = customTitle;
        return this;
    }

    protected abstract GUI createGUI();

    public void recreateGUI() {
        this.gui = this.createGUI();
        this.gui.setVisible(true);
    }

    protected void containerTick() {
        super.containerTick();
        this.gui.fireEvent(new UpdateScreenEvent());
        if (((WidgetContainer)this.menu).isGuiDirty()) {
            this.gui.fireEvent(new GuiDataUpdatedEvent());
            ((WidgetContainer)this.menu).cleaned();
        }
        this.resetMousePositions();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.gui.fireEvent(new MouseClickEvent(mouseX, mouseY, mouseButton)) == WidgetEventResult.CONTINUE_PROCESSING) {
            return super.mouseClicked(mouseX, mouseY, mouseButton);
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        Slot slot = this.getSlotUnderMouse();
        if (this.gui.fireEvent(new MouseReleasedEvent(mouseX, mouseY, mouseButton)) == WidgetEventResult.CONTINUE_PROCESSING) {
            return super.mouseReleased(mouseX, mouseY, mouseButton);
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.gui.fireEvent(new MouseDraggedEvent(mouseX, mouseY, button, dragX, dragY)) == WidgetEventResult.CONTINUE_PROCESSING) {
            return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        }
        return false;
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (this.gui.fireEvent(new KeyReleasedEvent(keyCode, scanCode, modifiers)) == WidgetEventResult.CONTINUE_PROCESSING) {
            return super.keyReleased(keyCode, scanCode, modifiers);
        }
        return false;
    }

    public boolean charTyped(char chr, int code) {
        if (this.gui.fireEvent(new CharTypedEvent(chr, code)) == WidgetEventResult.CONTINUE_PROCESSING) {
            return super.charTyped(chr, code);
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.gui.fireEvent(new KeyPressedEvent(keyCode, scanCode, modifiers)) == WidgetEventResult.CONTINUE_PROCESSING) {
            return super.keyPressed(keyCode, scanCode, modifiers);
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.gui.fireEvent(new MouseScrollEvent(mouseX, mouseY, scrollY)) == WidgetEventResult.CONTINUE_PROCESSING) {
            return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }
        return false;
    }

    protected void renderLabels(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        if (this.renderInventoryTitle) {
            int minY = this.height;
            for (Slot slot : ((WidgetContainer)this.menu).slots) {
                WidgetSlot ws;
                if (!(slot instanceof WidgetSlot) || (ws = (WidgetSlot)slot).getGroupId() != WidgetContainer.SLOTGROUP_PLAYER || ws.y >= minY) continue;
                minY = ws.y;
            }
            Objects.requireNonNull(this.font);
            this.inventoryLabelY = minY - (9 + 2);
            pGuiGraphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, 0x404040, false);
        }
        if (this.renderTitle) {
            pGuiGraphics.drawString(this.font, this.customTitle != null ? this.customTitle : this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
        }
        pGuiGraphics.pose().pushPose();
        pGuiGraphics.pose().translate((float)(-this.getGuiLeft()), (float)(-this.getGuiTop() + 18), 0.0f);
        this.gui.drawTooltips(pGuiGraphics, (Screen)this, pMouseX, pMouseY);
        try {
            this.renderTooltip(pGuiGraphics, pMouseX, pMouseY);
        }
        catch (Exception exception) {
            // empty catch block
        }
        pGuiGraphics.pose().popPose();
    }

    public void render(GuiGraphics pGuiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.dataUpdated) {
            this.dataUpdated = false;
            this.gui.fireEvent(new GuiDataUpdatedEvent());
        }
        if (mouseX != this.previousMouseX || mouseY != this.previousMouseY) {
            this.gui.fireEvent(new MouseMoveEvent(mouseX, mouseY));
            this.previousMouseX = mouseX;
            this.previousMouseY = mouseY;
        }
        super.render(pGuiGraphics, mouseX, mouseY, partialTicks);
    }

    protected void renderBg(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        this.gui.drawGUI(pGuiGraphics, (Screen)this);
        if (this.menu != null && ((WidgetContainer)this.menu).slots != null) {
            for (Slot slot : ((WidgetContainer)this.menu).slots) {
                WidgetSlot widgetSlot;
                if (!(slot instanceof WidgetSlot) || !(widgetSlot = (WidgetSlot)slot).isEnabled()) continue;
                this.gui.drawSlot(pGuiGraphics, (Screen)this, slot, this.leftPos, this.topPos);
            }
        }
    }

    protected void resetMousePositions() {
        this.previousMouseX = Integer.MIN_VALUE;
        this.previousMouseY = Integer.MIN_VALUE;
    }

    public void fireDataUpdateEvent() {
        this.dataUpdated = true;
    }
}

