/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.pipegoggles.lib.gui;

import com.davenonymous.pipegoggles.PipeGoggles;
import com.davenonymous.pipegoggles.lib.gui.DynamicImageResources;
import com.davenonymous.pipegoggles.lib.gui.GUISpriteInfo;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL11;

public class GUIHelper {
    public static ResourceLocation tabIcons = PipeGoggles.resource("textures/gui/tabicons.png");
    private static Map<Integer, DynamicImageResources.DynTexture> circleCache = new HashMap<Integer, DynamicImageResources.DynTexture>();

    private static DynamicImageResources.DynTexture getCircleTexture(int radius) {
        if (circleCache.containsKey(radius)) {
            return circleCache.get(radius);
        }
        TextureManager tm = Minecraft.getInstance().getTextureManager();
        int diameter = radius * 2 + 1;
        NativeImage image = new NativeImage(diameter, diameter, true);
        int rmin = radius * radius - radius;
        int rmax = radius * radius + radius;
        for (int y = -radius; y <= radius; ++y) {
            int sqy = y * y;
            for (int x = -radius; x <= radius; ++x) {
                int sqd = x * x + sqy;
                if (sqd < rmin) {
                    image.setPixelRGBA(x + radius, y + radius, -1);
                    continue;
                }
                if (sqd >= rmax) continue;
                int c = rmax - sqd;
                c *= 256;
                if ((c /= 2 * radius) > 255) {
                    c = 255;
                }
                image.setPixelRGBA(x + radius, y + radius, (c << 24) + 0xFFFFFF);
            }
        }
        ResourceLocation resource = tm.register("circle_" + radius, new DynamicTexture(image){

            public void upload() {
                this.bind();
                NativeImage td = this.getPixels();
                this.getPixels().upload(0, 0, 0, 0, 0, td.getWidth(), td.getHeight(), false, false, false, false);
            }
        });
        DynamicImageResources.DynTexture result = new DynamicImageResources.DynTexture(resource, image);
        circleCache.put(radius, result);
        return result;
    }

    public static void drawFilledCircle(GuiGraphics guiGraphics, float x, float y, int radius, int color) {
        DynamicImageResources.DynTexture circleTexture = GUIHelper.getCircleTexture(radius);
        int diameter = radius * 2;
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        GUIHelper.setShaderColor(color);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(x, y, 1.0f);
        guiGraphics.blitInscribed(circleTexture.resource(), 0, 0, diameter, diameter, diameter, diameter, true, true);
        guiGraphics.pose().popPose();
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawLine(GuiGraphics guiGraphics, int x1, int y1, int x2, int y2, int color) {
        GUIHelper.drawLine(guiGraphics, x1, y1, x2, y2, color, color);
    }

    public static void drawLine(GuiGraphics guiGraphics, int x1, int y1, int x2, int y2, int color1, int color2) {
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.enableBlend();
        Matrix4f matrix4f = guiGraphics.pose().last().pose();
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.POSITION_COLOR);
        GL11.glEnable((int)2848);
        bufferbuilder.addVertex(matrix4f, (float)x1, (float)y1, 0.0f).setColor(color1);
        bufferbuilder.addVertex(matrix4f, (float)x2, (float)y2, 0.0f).setColor(color2);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        GL11.glDisable((int)2848);
        RenderSystem.disableBlend();
    }

    public static void drawLine(PoseStack poseStack, float x1, float y1, float z1, float x2, float y2, float z2, int color1, int color2) {
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.enableBlend();
        Matrix4f matrix4f = poseStack.last().pose();
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.POSITION_COLOR);
        GL11.glEnable((int)2848);
        bufferbuilder.addVertex(matrix4f, x1, y1, z1).setColor(color1);
        bufferbuilder.addVertex(matrix4f, x2, y2, z2).setColor(color2);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        GL11.glDisable((int)2848);
        RenderSystem.disableBlend();
    }

    public static void setShaderColor(int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
    }

    public static int brighten(int color, float factor) {
        float r = (float)(color >> 16 & 0xFF) * factor;
        float g = (float)(color >> 8 & 0xFF) * factor;
        float b = (float)(color & 0xFF) * factor;
        float a = color >> 24 & 0xFF;
        float threshold = 255.999f;
        float max = Math.max(Math.max(r, g), b);
        if (max <= threshold) {
            return ((int)a << 24) + ((int)r << 16) + ((int)g << 8) + (int)b;
        }
        float total = r + g + b;
        if (total >= 3.0f * threshold) {
            return ((int)a << 24) + ((int)threshold << 16) + ((int)threshold << 8) + (int)threshold;
        }
        float x = (3.0f * threshold - total) / (3.0f * max - total);
        float gray = threshold - x * max;
        int newR = (int)(gray + x * r);
        int newG = (int)(gray + x * g);
        int newB = (int)(gray + x * b);
        return ((int)a << 24) + ((newR & 0xFF) << 16) + ((newG & 0xFF) << 8) + (newB & 0xFF);
    }

    public static void fillHorizontalGradient(GuiGraphics guiGraphics, int x1, int y1, int x2, int y2, int colorFrom, int colorTo) {
        GUIHelper.fillHorizontalGradient(guiGraphics, x1, y1, x2, y2, 0, colorFrom, colorTo);
    }

    public static void fillHorizontalGradient(GuiGraphics guiGraphics, int x1, int y1, int x2, int y2, int z, int colorFrom, int colorTo) {
        GUIHelper.fillHorizontalGradient(guiGraphics, RenderType.gui(), x1, y1, x2, y2, colorFrom, colorTo, z);
    }

    public static void fillHorizontalGradient(GuiGraphics guiGraphics, RenderType renderType, int x1, int y1, int x2, int y2, int colorFrom, int colorTo, int z) {
        VertexConsumer vertexconsumer = guiGraphics.bufferSource().getBuffer(renderType);
        GUIHelper.fillHorizontalGradient(guiGraphics, vertexconsumer, x1, y1, x2, y2, z, colorFrom, colorTo);
    }

    private static void fillHorizontalGradient(GuiGraphics guiGraphics, VertexConsumer consumer, int x1, int y1, int x2, int y2, int z, int colorFrom, int colorTo) {
        Matrix4f matrix4f = guiGraphics.pose().last().pose();
        consumer.addVertex(matrix4f, (float)x1, (float)y1, (float)z).setColor(colorFrom);
        consumer.addVertex(matrix4f, (float)x1, (float)y2, (float)z).setColor(colorFrom);
        consumer.addVertex(matrix4f, (float)x2, (float)y2, (float)z).setColor(colorTo);
        consumer.addVertex(matrix4f, (float)x2, (float)y1, (float)z).setColor(colorTo);
    }

    public static Vector4f shortenLineSym(int x1, int y1, int x2, int y2, float length) {
        float angle = (float)Math.atan2(y2 - y1, x2 - x1);
        float newX1 = (float)x1 + length * (float)Math.cos(angle);
        float newY1 = (float)y1 + length * (float)Math.sin(angle);
        float newX2 = (float)x2 - length * (float)Math.cos(angle);
        float newY2 = (float)y2 - length * (float)Math.sin(angle);
        return new Vector4f(newX1, newY1, newX2, newY2);
    }

    public static Vector2f drawFatLine(GuiGraphics guiGraphics, float x1, float y1, float x2, float y2, float lineWidth, int color) {
        float angle = (float)Math.atan2(y2 - y1, x2 - x1);
        float length = (float)Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.enableBlend();
        float midX = (x1 + x2) / 2.0f;
        float midY = (y1 + y2) / 2.0f;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(midX - length / 2.0f, midY - lineWidth / 2.0f, 0.0f);
        guiGraphics.pose().rotateAround(Axis.ZP.rotationDegrees((float)Math.toDegrees(angle)), length / 2.0f, lineWidth / 2.0f, 0.0f);
        guiGraphics.fill(0, 0, (int)length, Math.round(lineWidth), color);
        guiGraphics.pose().popPose();
        RenderSystem.disableBlend();
        return new Vector2f(angle, length);
    }

    public static Vector2f drawTiledLine(GuiGraphics guiGraphics, float x1, float y1, float x2, float y2, GUISpriteInfo spriteInfo, int color) {
        return GUIHelper.drawTiledLine(guiGraphics, x1, y1, x2, y2, spriteInfo, color, 0);
    }

    public static Vector2f drawTiledLine(GuiGraphics guiGraphics, float x1, float y1, float x2, float y2, GUISpriteInfo spriteInfo, int color, int padding) {
        float angle = (float)Math.atan2(y2 - y1, x2 - x1);
        float length = (float)Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
        int lineWidth = spriteInfo.height();
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.enableBlend();
        float midX = (x1 + x2) / 2.0f;
        float midY = (y1 + y2) / 2.0f;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(midX - length / 2.0f, midY - (float)lineWidth / 2.0f, 0.0f);
        guiGraphics.pose().rotateAround(Axis.ZP.rotationDegrees((float)Math.toDegrees(angle)), length / 2.0f, (float)lineWidth / 2.0f, 0.0f);
        GUIHelper.setShaderColor(color);
        int xPos = 0;
        while ((float)xPos < length) {
            guiGraphics.blit(spriteInfo.sprite(), xPos, 0, 0.0f, 0.0f, spriteInfo.width(), spriteInfo.height(), spriteInfo.width(), spriteInfo.height());
            xPos += spriteInfo.width() + padding;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.pose().popPose();
        RenderSystem.disableBlend();
        return new Vector2f(angle, length);
    }

    public static void drawArrowHead(GuiGraphics guiGraphics, float x1, float y1, float x2, float y2, int color) {
        float angle = (float)Math.atan2(y2 - y1, x2 - x1);
        float length = (float)Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
        float midX = (x1 + x2) / 2.0f;
        float midY = (y1 + y2) / 2.0f;
        ResourceLocation arrowHeadTexture = PipeGoggles.resource("textures/gui/arrowhead.png");
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)arrowHeadTexture);
        RenderSystem.enableBlend();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(midX - 6.0f, midY - 6.0f, 0.0f);
        guiGraphics.pose().rotateAround(Axis.ZP.rotationDegrees((float)Math.toDegrees(angle)), 6.0f, 6.0f, 0.0f);
        guiGraphics.fill(2, 2, 10, 10, -1);
        GUIHelper.setShaderColor(color);
        guiGraphics.blit(arrowHeadTexture, 0, 0, 0.0f, 0.0f, 12, 12, 12, 12);
        guiGraphics.pose().popPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    public static void drawArrowLine(GuiGraphics guiGraphics, float x1, float y1, float x2, float y2, float lineWidth, int color) {
        GUIHelper.drawFatLine(guiGraphics, x1, y1, x2, y2, lineWidth, color);
        GUIHelper.drawArrowHead(guiGraphics, x1, y1, x2, y2, color);
    }

    public static int longestWrappedLine(Font font, FormattedText text, int lineWidth) {
        int longest = 0;
        for (FormattedCharSequence formattedcharsequence : font.split(text, lineWidth)) {
            longest = Math.max(longest, font.width(formattedcharsequence));
        }
        return longest;
    }

    public static void drawWordWrap(GuiGraphics pGuiGraphics, Font font, FormattedText text, int x, int y, int lineWidth, int color) {
        for (FormattedCharSequence formattedcharsequence : font.split(text, lineWidth)) {
            pGuiGraphics.drawString(font, formattedcharsequence, x, y, color, false);
            y += 10;
        }
    }

    public static int wordWrapHeight(Font font, FormattedText text, int maxWidth) {
        return 10 * font.split(text, maxWidth).size();
    }

    public static void drawStringCentered(GuiGraphics pGuiGraphics, String str, Screen screen, float x, float y, int color) {
        Font renderer = screen.getMinecraft().font;
        float xPos = x - (float)renderer.width(str) / 2.0f;
        ShaderInstance old = RenderSystem.getShader();
        pGuiGraphics.drawCenteredString(renderer, str, (int)xPos, (int)y, color);
        RenderSystem.setShader(() -> old);
    }

    public static void drawSplitStringCentered(GuiGraphics pGuiGraphics, String str, Screen screen, int x, int y, int width, int color) {
        Font renderer = screen.getMinecraft().font;
        int yOffset = 0;
        for (FormattedText row : renderer.getSplitter().splitLines(str, width, Style.EMPTY)) {
            GUIHelper.drawStringCentered(pGuiGraphics, row.getString(), screen, x + width / 2, y + yOffset, color);
            Objects.requireNonNull(renderer);
            yOffset += 9;
        }
    }

    public static void drawColoredRectangle(GuiGraphics pGuiGraphics, int x, int y, int width, int height, int argb) {
        int a = argb >> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        GUIHelper.drawColoredRectangle(pGuiGraphics, x, y, width, height, r, g, b, a);
    }

    public static void drawColoredRectangle(GuiGraphics pGuiGraphics, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        float zLevel = 0.0f;
    }

    public static void drawStretchedTabIconsTexture(GuiGraphics pGuiGraphics, int x, int y, int width, int height, int textureX, int textureY, int textureWidth, int textureHeight) {
        float uScale = 0.00390625f;
        float vScale = 0.00390625f;
        float zLevel = 0.0f;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)tabIcons);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        Matrix4f matrix = pGuiGraphics.pose().last().pose();
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        builder.addVertex(matrix, (float)x, (float)(y + height), zLevel).setUv((float)textureX * 0.00390625f, (float)(textureY + textureHeight) * 0.00390625f);
        builder.addVertex(matrix, (float)(x + width), (float)(y + height), zLevel).setUv((float)(textureX + textureWidth) * 0.00390625f, (float)(textureY + textureHeight) * 0.00390625f);
        builder.addVertex(matrix, (float)(x + width), (float)y, zLevel).setUv((float)(textureX + textureWidth) * 0.00390625f, (float)textureY * 0.00390625f);
        builder.addVertex(matrix, (float)x, (float)y, zLevel).setUv((float)textureX * 0.00390625f, (float)textureY * 0.00390625f);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
    }

    public static void drawStretchedTexture(GuiGraphics pGuiGraphics, ResourceLocation texture, int x, int y, int width, int height, int textureX, int textureY, int textureWidth, int textureHeight) {
        float uScale = 0.00390625f;
        float vScale = 0.00390625f;
        float zLevel = 0.0f;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        Matrix4f matrix = pGuiGraphics.pose().last().pose();
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        builder.addVertex(matrix, (float)x, (float)(y + height), zLevel).setUv((float)textureX * 0.00390625f, (float)(textureY + textureHeight) * 0.00390625f);
        builder.addVertex(matrix, (float)(x + width), (float)(y + height), zLevel).setUv((float)(textureX + textureWidth) * 0.00390625f, (float)(textureY + textureHeight) * 0.00390625f);
        builder.addVertex(matrix, (float)(x + width), (float)y, zLevel).setUv((float)(textureX + textureWidth) * 0.00390625f, (float)textureY * 0.00390625f);
        builder.addVertex(matrix, (float)x, (float)y, zLevel).setUv((float)textureX * 0.00390625f, (float)textureY * 0.00390625f);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
    }

    public static void drawModalRectWithCustomSizedTexture(GuiGraphics pGuiGraphics, int x, int y, float u, float v, int width, int height, float textureWidth, float textureHeight) {
        float f = 1.0f / textureWidth;
        float f1 = 1.0f / textureHeight;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)tabIcons);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        Matrix4f matrix = pGuiGraphics.pose().last().pose();
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        builder.addVertex(matrix, (float)x, (float)(y + height), 0.0f).setUv(u * f, (v + (float)height) * f1);
        builder.addVertex(matrix, (float)(x + width), (float)(y + height), 0.0f).setUv((u + (float)width) * f, (v + (float)height) * f1);
        builder.addVertex(matrix, (float)(x + width), (float)y, 0.0f).setUv((u + (float)width) * f, v * f1);
        builder.addVertex(matrix, (float)x, (float)y, 0.0f).setUv(u * f, v * f1);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
    }

    public static void renderGuiItem(GuiGraphics pGuiGraphics, ItemStack pStack, int pX, int pY, boolean blackOut) {
        boolean flag;
        BakedModel pBakedmodel = Minecraft.getInstance().getItemRenderer().getModel(pStack, null, null, 0);
        Minecraft.getInstance().getTextureManager().getTexture(TextureAtlas.LOCATION_BLOCKS).setFilter(false, false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_BLOCKS);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack posestack = pGuiGraphics.pose();
        posestack.pushPose();
        posestack.translate((double)pX, (double)pY, 100.0);
        posestack.translate(8.0, 8.0, 0.0);
        posestack.scale(1.0f, -1.0f, 1.0f);
        posestack.scale(16.0f, 16.0f, 16.0f);
        RenderSystem.applyModelViewMatrix();
        PoseStack posestack1 = new PoseStack();
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.getInstance().renderBuffers().bufferSource();
        boolean bl = flag = !pBakedmodel.usesBlockLight();
        if (flag) {
            Lighting.setupForFlatItems();
        }
        Minecraft.getInstance().getItemRenderer().render(pStack, ItemDisplayContext.GUI, false, posestack1, (MultiBufferSource)multibuffersource$buffersource, blackOut ? 0 : 0xF000F0, OverlayTexture.NO_OVERLAY, pBakedmodel);
        multibuffersource$buffersource.endBatch();
        RenderSystem.enableDepthTest();
        if (flag) {
            Lighting.setupFor3DItems();
        }
        posestack.popPose();
        RenderSystem.applyModelViewMatrix();
    }

    public static void fillAreaWithIcon(GuiGraphics pGuiGraphics, TextureAtlasSprite icon, int x, int y, int width, int height) {
        int xNow;
        int yNow;
        Tesselator t = Tesselator.getInstance();
        BufferBuilder b = t.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        float zLevel = 0.0f;
        int iconWidth = icon.contents().width();
        int iconHeight = icon.contents().height();
        int fullCols = width / iconWidth;
        int fullRows = height / iconHeight;
        float minU = icon.getU0();
        float maxU = icon.getU1();
        float minV = icon.getV0();
        float maxV = icon.getV1();
        int excessWidth = width % iconWidth;
        int excessHeight = height % iconHeight;
        float partialMaxU = minU + (maxU - minU) * ((float)excessWidth / (float)iconWidth);
        float partialMaxV = minV + (maxV - minV) * ((float)excessHeight / (float)iconHeight);
        for (int row = 0; row < fullRows; ++row) {
            yNow = y + row * iconHeight;
            for (int col = 0; col < fullCols; ++col) {
                xNow = x + col * iconWidth;
                GUIHelper.drawRect(pGuiGraphics, xNow, yNow, iconWidth, iconHeight, zLevel, minU, minV, maxU, maxV);
            }
            if (excessWidth == 0) continue;
            xNow = x + fullCols * iconWidth;
            GUIHelper.drawRect(pGuiGraphics, xNow, yNow, iconWidth, iconHeight, zLevel, minU, minV, maxU, maxV);
        }
        if (excessHeight != 0) {
            for (int col = 0; col < fullCols; ++col) {
                xNow = x + col * iconWidth;
                yNow = y + fullRows * iconHeight;
                GUIHelper.drawRect(pGuiGraphics, xNow, yNow, iconWidth, excessHeight, zLevel, minU, minV, maxU, partialMaxV);
            }
            if (excessWidth != 0) {
                xNow = x + fullCols * iconWidth;
                yNow = y + fullRows * iconHeight;
                GUIHelper.drawRect(pGuiGraphics, xNow, yNow, excessWidth, excessHeight, zLevel, minU, minV, partialMaxU, partialMaxV);
            }
        }
        b.build();
    }

    private static void drawRect(GuiGraphics pGuiGraphics, float x, float y, float width, float height, float z, float u, float v, float maxU, float maxV) {
        BufferBuilder b = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        b.addVertex(x, y + height, z).setUv(u, maxV);
        b.addVertex(x + width, y + height, z).setUv(maxU, maxV);
        b.addVertex(x + width, y, z).setUv(maxU, v);
        b.addVertex(x, y, z).setUv(u, v);
        b.build();
    }

    public static void drawEmbossedWindow(GuiGraphics pGuiGraphics, ResourceLocation texture, int pWidth, int pHeight) {
        GUIHelper.drawEmbossedWindow(pGuiGraphics, texture, pWidth, pHeight, 0, 0);
    }

    public static void drawEmbossedWindow(GuiGraphics pGuiGraphics, ResourceLocation texture, int pWidth, int pHeight, int x, int y) {
        boolean texOffsetY = false;
        boolean texOffsetX = false;
        int borderSize = 8;
        int width = pWidth;
        int xOffset = x;
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        pGuiGraphics.blit(texture, x, y, borderSize, borderSize, 0.0f, 0.0f, borderSize, borderSize, 64, 64);
        pGuiGraphics.blit(texture, x + width - borderSize, y, borderSize, borderSize, 64.0f - (float)borderSize, 0.0f, borderSize, borderSize, 64, 64);
        pGuiGraphics.blit(texture, x, y + pHeight - borderSize, borderSize, borderSize, 0.0f, 64.0f - (float)borderSize, borderSize, borderSize, 64, 64);
        pGuiGraphics.blit(texture, x + width - borderSize, y + pHeight - borderSize, borderSize, borderSize, 64.0f - (float)borderSize, 64.0f - (float)borderSize, borderSize, borderSize, 64, 64);
        pGuiGraphics.blit(texture, x + 4, y, width - borderSize, borderSize, 0.0f + (float)borderSize, 0.0f, 52, borderSize, 64, 64);
        pGuiGraphics.blit(texture, x + 4, y + pHeight - borderSize, width - borderSize, borderSize, 0.0f + (float)borderSize, 64.0f - (float)borderSize, 52, borderSize, 64, 64);
        pGuiGraphics.blit(texture, x, y + borderSize, borderSize, pHeight - 2 * borderSize, 0.0f, (float)borderSize, borderSize, 8, 64, 64);
        pGuiGraphics.blit(texture, x + width - borderSize, y + borderSize, borderSize, pHeight - 2 * borderSize, (float)(64 - borderSize), (float)borderSize, borderSize, 8, 64, 64);
        pGuiGraphics.blit(texture, x + borderSize, y + borderSize, pWidth - 2 * borderSize, pHeight - 2 * borderSize, (float)borderSize, (float)borderSize, 52, 52, 64, 64);
    }

    public static void drawWindow(GuiGraphics pGuiGraphics, int pWidth, int pHeight, boolean hasTabs) {
        GUIHelper.drawWindow(pGuiGraphics, pWidth, pHeight, hasTabs, 0, 0);
    }

    public static void drawColoredCanvas(GuiGraphics pGuiGraphics, int pWidth, int pHeight, int color) {
        int texOffsetY = 85;
        int texOffsetX = 65;
        int width = pWidth;
        int xOffset = 0;
        int y = 0;
        pGuiGraphics.fill(0, 0, pWidth, pHeight, color);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)tabIcons);
        RenderSystem.enableBlend();
        int spriteSize = 18;
        int borderSize = 3;
        pGuiGraphics.blit(tabIcons, xOffset, y, texOffsetX, texOffsetY, borderSize, borderSize);
        pGuiGraphics.blit(tabIcons, xOffset + width - borderSize, y, texOffsetX + spriteSize - borderSize, texOffsetY, borderSize, borderSize);
        pGuiGraphics.blit(tabIcons, xOffset, y + pHeight - borderSize, texOffsetX, texOffsetY + spriteSize - borderSize, borderSize, borderSize);
        pGuiGraphics.blit(tabIcons, xOffset + width - borderSize, y + pHeight - borderSize, texOffsetX + spriteSize - borderSize, texOffsetY + spriteSize - borderSize, borderSize, borderSize);
        GUIHelper.drawStretchedTabIconsTexture(pGuiGraphics, xOffset + borderSize, y, width - 2 * borderSize, borderSize, texOffsetX + 4, texOffsetY, 1, borderSize);
        GUIHelper.drawStretchedTabIconsTexture(pGuiGraphics, xOffset + borderSize, y + pHeight - borderSize, width - 2 * borderSize, borderSize, texOffsetX + 4, texOffsetY + spriteSize - borderSize, 1, borderSize);
        GUIHelper.drawStretchedTabIconsTexture(pGuiGraphics, xOffset, y + borderSize, borderSize, pHeight - 2 * borderSize, texOffsetX, texOffsetY + 4, borderSize, 1);
        GUIHelper.drawStretchedTabIconsTexture(pGuiGraphics, xOffset + width - borderSize, y + borderSize, borderSize, pHeight - 2 * borderSize, texOffsetX + spriteSize - borderSize, texOffsetY + 4, borderSize, 1);
    }

    public static void drawWindow(GuiGraphics pGuiGraphics, int pWidth, int pHeight, boolean hasTabs, int x, int y) {
        int texOffsetY = 11;
        int texOffsetX = 64;
        int width = pWidth;
        int xOffset = x;
        if (hasTabs) {
            width -= 32;
            xOffset += 32;
        }
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)tabIcons);
        pGuiGraphics.blit(tabIcons, xOffset, y, texOffsetX, texOffsetY, 4, 4);
        pGuiGraphics.blit(tabIcons, xOffset + width - 4, y, texOffsetX + 4 + 64, texOffsetY, 4, 4);
        pGuiGraphics.blit(tabIcons, xOffset, y + pHeight - 4, texOffsetX, texOffsetY + 4 + 64, 4, 4);
        pGuiGraphics.blit(tabIcons, xOffset + width - 4, y + pHeight - 4, texOffsetX + 4 + 64, texOffsetY + 4 + 64, 4, 4);
        GUIHelper.drawStretchedTabIconsTexture(pGuiGraphics, xOffset + 4, y, width - 8, 4, texOffsetX + 4, texOffsetY, 64, 4);
        GUIHelper.drawStretchedTabIconsTexture(pGuiGraphics, xOffset + 4, y + pHeight - 4, width - 8, 4, texOffsetX + 4, texOffsetY + 4 + 64, 64, 4);
        GUIHelper.drawStretchedTabIconsTexture(pGuiGraphics, xOffset, y + 4, 4, pHeight - 8, texOffsetX, texOffsetY + 4, 4, 64);
        GUIHelper.drawStretchedTabIconsTexture(pGuiGraphics, xOffset + width - 4, y + 4, 4, pHeight - 8, texOffsetX + 64 + 4, texOffsetY + 3, 4, 64);
        GUIHelper.drawStretchedTabIconsTexture(pGuiGraphics, xOffset + 4, y + 4, width - 8, pHeight - 8, texOffsetX + 4, texOffsetY + 4, 64, 64);
    }
}

