/*
 * Decompiled with CFR 0.152.
 */
package com.heaser.pipeconnector.network;

import com.heaser.pipeconnector.network.CustomPipeConnectorPayload;
import com.heaser.pipeconnector.network.ServerboundPacket;
import com.heaser.pipeconnector.utils.GeneralUtils;
import com.heaser.pipeconnector.utils.TagUtils;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public record UpdateUtilizeExistingPipes(boolean utilizeExistingPipes) implements ServerboundPacket
{
    public static final StreamCodec<RegistryFriendlyByteBuf, UpdateUtilizeExistingPipes> STREAM_CODEC = StreamCodec.ofMember(UpdateUtilizeExistingPipes::write, UpdateUtilizeExistingPipes::decode);
    public static final CustomPacketPayload.Type<UpdateUtilizeExistingPipes> TYPE = CustomPipeConnectorPayload.createType("update_utilize_existing_pipes");

    public CustomPacketPayload.Type<UpdateUtilizeExistingPipes> type() {
        return TYPE;
    }

    public static UpdateUtilizeExistingPipes decode(RegistryFriendlyByteBuf buf) {
        return new UpdateUtilizeExistingPipes(buf.readBoolean());
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeBoolean(this.utilizeExistingPipes);
    }

    @Override
    public void handleOnServer(ServerPlayer player) {
        if (player == null) {
            return;
        }
        if (!GeneralUtils.isHoldingPipeConnector((Player)player)) {
            return;
        }
        ItemStack item = player.getMainHandItem();
        TagUtils.setUtilizeExistingPipes(item, this.utilizeExistingPipes);
    }
}

