/*
 * Decompiled with CFR 0.152.
 */
package com.heaser.pipeconnector.compatibility.jei;

import com.heaser.pipeconnector.compatibility.interfaces.IRecipeInfoGetter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.ModList;

public class CompatibilityRecipeInfoGetter {
    private static CompatibilityRecipeInfoGetter INSTANCE;
    private static final HashMap<Class<? extends Item>, IRecipeInfoGetter> classToGetterMap;

    private CompatibilityRecipeInfoGetter() {
    }

    public static CompatibilityRecipeInfoGetter getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CompatibilityRecipeInfoGetter();
        }
        return INSTANCE;
    }

    private boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    public Stream<ItemStack> getSupportedPipeItems(ItemStack supportedBaseItemStack) {
        for (Map.Entry<Class<? extends Item>, IRecipeInfoGetter> set : classToGetterMap.entrySet()) {
            Item supportedBaseItem = supportedBaseItemStack.getItem();
            if (!set.getKey().isAssignableFrom(supportedBaseItem.getClass())) continue;
            return set.getValue().getSupportedPipeItems(supportedBaseItemStack).stream();
        }
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        result.add(supportedBaseItemStack);
        return result.stream();
    }

    static {
        classToGetterMap = new HashMap();
    }
}

