/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particular.particles;

import com.leclowndu93150.particular.mixin.AccessorParticle;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.level.levelgen.synth.SimplexNoise;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class FireflyParticle
extends TextureSheetParticle {
    private static final int minOffTime = 40;
    private static final int maxOffTime = 80;
    private static final int minOnTime = 10;
    private static final int maxOnTime = 20;
    private final SimplexNoise noise;
    private int ageOffset = 0;
    private int ticksUntilNextSwitch = 40;
    private boolean isOn = false;

    protected FireflyParticle(ClientLevel world, double x, double y, double z, SpriteSet provider) {
        super(world, x, y, z);
        this.pickSprite(provider);
        this.gravity = 0.0f;
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        this.alpha = 0.0f;
        this.rCol = 0.73333335f;
        this.gCol = 1.0f;
        this.bCol = 0.41960785f;
        if (world.getRandom().nextInt(10) == 1) {
            this.rCol = 0.41960785f;
            this.gCol = 0.98039216f;
            this.bCol = 1.0f;
            if (world.getRandom().nextInt(10) == 1) {
                this.rCol = 1.0f;
                this.gCol = 0.4862745f;
                this.bCol = 0.41960785f;
            }
        }
        this.lifetime = 200;
        this.quadSize = 0.25f;
        this.noise = new SimplexNoise(this.random);
    }

    public void tick() {
        super.tick();
        if (this.onGround) {
            ((AccessorParticle)((Object)this)).setStopped(false);
            this.ageOffset += 5;
        }
        if (--this.ticksUntilNextSwitch <= 0) {
            if (this.isOn) {
                this.isOn = false;
                this.ticksUntilNextSwitch = this.random.nextIntBetweenInclusive(40, 80);
            } else {
                this.isOn = true;
                this.ticksUntilNextSwitch = this.random.nextIntBetweenInclusive(10, 20);
            }
        }
        this.alpha = this.isOn && this.lifetime - this.age > 3 ? Math.min(1.0f, this.alpha + 0.33f) : Math.max(0.0f, this.alpha - 0.33f);
        float speedFactor = 0.1f;
        float noiseFactor = 0.0033333334f;
        this.xd = this.noise.getValue((double)((float)this.age * noiseFactor), (double)((float)this.age * noiseFactor)) * (double)speedFactor;
        this.yd = this.noise.getValue((double)((float)(this.age + this.ageOffset) * noiseFactor - 50.0f), (double)((float)(this.age + this.ageOffset) * noiseFactor + 100.0f)) * (double)speedFactor * 0.5;
        this.zd = this.noise.getValue((double)((float)this.age * noiseFactor + 100.0f), (double)((float)this.age * noiseFactor - 50.0f)) * (double)speedFactor;
        speedFactor = 1.0f / (10.0f + (float)Math.sin(Math.PI + (double)((float)this.age / 30.0f)) * 2.0f);
        noiseFactor = 0.033333335f;
        this.xd += this.noise.getValue((double)((float)this.age * noiseFactor), (double)((float)this.age * noiseFactor)) * (double)speedFactor * 0.5;
        this.yd += this.noise.getValue((double)((float)(this.age + this.ageOffset) * noiseFactor - 50.0f), (double)((float)(this.age + this.ageOffset) * noiseFactor + 100.0f)) * (double)speedFactor;
        this.zd += this.noise.getValue((double)((float)this.age * noiseFactor + 100.0f), (double)((float)this.age * noiseFactor - 50.0f)) * (double)speedFactor * 0.5;
    }

    protected int getLightColor(float tint) {
        return 0xF000F0;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet provider;

        public Factory(SpriteSet provider) {
            this.provider = provider;
        }

        public Particle createParticle(SimpleParticleType parameters, ClientLevel world, double x, double y, double z, double velX, double velY, double velZ) {
            return new FireflyParticle(world, x, y, z, this.provider);
        }
    }
}

