/*
 * Decompiled with CFR 0.152.
 */
package com.lumengrid.oritechthings.mixin;

import com.lumengrid.oritechthings.block.custom.TierAddonBlock;
import com.lumengrid.oritechthings.util.Constants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import rearth.oritech.block.blocks.accelerator.AcceleratorMotorBlock;
import rearth.oritech.block.blocks.addons.MachineAddonBlock;
import rearth.oritech.init.BlockContent;

@Mixin(value={MachineAddonBlock.class})
public class MachineAddonBlockMixin {
    @Inject(method={"setPlacedBy"}, at={@At(value="TAIL")})
    private void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack, CallbackInfo ci) {
        if (world.isClientSide) {
            return;
        }
        BlockPos motorPos = pos.offset(Direction.UP.getNormal());
        BlockState motorState = world.getBlockState(motorPos);
        if (motorState.getBlock() instanceof AcceleratorMotorBlock && this.isCompatibleAddon(state)) {
            BlockState newState = (BlockState)state.setValue((Property)MachineAddonBlock.ADDON_USED, (Comparable)Boolean.valueOf(true));
            world.setBlockAndUpdate(pos, newState);
            world.updateNeighborsAt(pos, state.getBlock());
        }
    }

    private boolean isCompatibleAddon(BlockState addonState) {
        Block addonBlock = addonState.getBlock();
        if (addonBlock instanceof TierAddonBlock) {
            Constants.AddonType addonType = (Constants.AddonType)((Object)addonState.getValue(TierAddonBlock.ADDON_TYPE));
            return addonType == Constants.AddonType.SPEED || addonType == Constants.AddonType.EFFICIENCY || addonType == Constants.AddonType.EFFICIENT_SPEED;
        }
        if (addonBlock instanceof MachineAddonBlock) {
            return addonBlock.equals(BlockContent.MACHINE_SPEED_ADDON) || addonBlock.equals(BlockContent.MACHINE_EFFICIENCY_ADDON) || addonBlock.equals(BlockContent.MACHINE_ULTIMATE_ADDON);
        }
        return false;
    }
}

