/*
 * Decompiled with CFR 0.152.
 */
package com.lumengrid.oritechthings.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.SimpleEnergyItemStorage;
import rearth.oritech.util.TooltipHelper;

public class AcceleratorMagneticFieldBlockItem
extends BlockItem
implements EnergyApi.ItemProvider {
    public AcceleratorMagneticFieldBlockItem(Block block, Item.Properties settings) {
        super(block, settings);
    }

    public void appendHoverText(ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag type) {
        long storedEnergy = (Long)stack.getOrDefault(EnergyApi.ITEM.getEnergyComponent(), (Object)0L);
        if (storedEnergy != 0L) {
            MutableComponent text = Component.translatable((String)"tooltip.oritech.energy_stored", (Object[])new Object[]{TooltipHelper.getEnergyText((long)storedEnergy)});
            tooltip.add((Component)text.withStyle(ChatFormatting.GOLD));
        }
        super.appendHoverText(stack, context, tooltip, type);
    }

    public boolean isBarVisible(ItemStack stack) {
        boolean contentEmpty = (Long)stack.getOrDefault(EnergyApi.ITEM.getEnergyComponent(), (Object)0L) <= 0L;
        return !contentEmpty;
    }

    public int getBarColor(@NotNull ItemStack stack) {
        return 0xFF7007;
    }

    public int getBarWidth(ItemStack stack) {
        long capacity = 500000L;
        long fillAmount = (Long)stack.getOrDefault(EnergyApi.ITEM.getEnergyComponent(), (Object)0L);
        if (fillAmount <= 0L) {
            return 0;
        }
        if (fillAmount >= capacity) {
            return 0;
        }
        return Math.round((float)fillAmount * 100.0f / (float)capacity * 13.0f) / 100;
    }

    public EnergyApi.EnergyStorage getEnergyStorage(ItemStack stack) {
        return new SimpleEnergyItemStorage(20000L, 0L, 500000L, stack);
    }
}

