/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.accelerator;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import rearth.oritech.block.entity.accelerator.AcceleratorParticleLogic;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.util.ComparatorOutputProvider;

public class AcceleratorSensorBlockEntity
extends BlockEntity
implements BlockEntityTicker<AcceleratorSensorBlockEntity>,
ComparatorOutputProvider {
    private float measuredSpeed;
    private long measuredTime;
    private boolean dirty = false;

    public AcceleratorSensorBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.ACCELERATOR_SENSOR_BLOCK_ENTITY, pos, state);
    }

    public void tick(Level world, BlockPos pos, BlockState state, AcceleratorSensorBlockEntity blockEntity) {
        long age;
        if (world.isClientSide) {
            return;
        }
        if (this.measuredSpeed != 0.0f && (age = world.getGameTime() - this.measuredTime) > 8L) {
            this.measuredSpeed = 0.0f;
            this.dirty = true;
        }
        if (this.dirty) {
            this.dirty = false;
            world.updateNeighbourForOutputSignal(pos, this.getBlockState().getBlock());
        }
    }

    public void measureParticle(AcceleratorParticleLogic.ActiveParticle particle) {
        this.measuredSpeed = particle.velocity;
        this.measuredTime = this.level.getGameTime();
        this.dirty = true;
    }

    @Override
    public int getComparatorOutput() {
        if (this.measuredSpeed <= 0.0f) {
            return 0;
        }
        if (this.measuredSpeed <= 10.0f) {
            return 1;
        }
        if (this.measuredSpeed <= 50.0f) {
            return 2;
        }
        if (this.measuredSpeed <= 75.0f) {
            return 3;
        }
        if (this.measuredSpeed <= 100.0f) {
            return 4;
        }
        if (this.measuredSpeed <= 150.0f) {
            return 5;
        }
        if (this.measuredSpeed <= 250.0f) {
            return 6;
        }
        if (this.measuredSpeed <= 500.0f) {
            return 7;
        }
        if (this.measuredSpeed <= 750.0f) {
            return 8;
        }
        if (this.measuredSpeed <= 1000.0f) {
            return 9;
        }
        if (this.measuredSpeed <= 2500.0f) {
            return 10;
        }
        if (this.measuredSpeed <= 5000.0f) {
            return 11;
        }
        if (this.measuredSpeed <= 7500.0f) {
            return 12;
        }
        if (this.measuredSpeed <= 10000.0f) {
            return 13;
        }
        if (this.measuredSpeed <= 15000.0f) {
            return 14;
        }
        return 15;
    }
}

