/*
 * Decompiled with CFR 0.152.
 */
package com.omnitools.omniTools.compat.mekanism;

import com.omnitools.omniTools.api.IWrenchHandler;
import com.omnitools.omniTools.api.WrenchContext;
import com.omnitools.omniTools.core.ToolMode;
import mekanism.api.IConfigurable;
import mekanism.api.security.IBlockSecurityUtils;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.BlockCapability;

public class MekanismTransmitterWrenchHandler
implements IWrenchHandler {
    @Override
    public boolean canHandle(WrenchContext context) {
        Level level = context.getLevel();
        if (level == null || level.isClientSide()) {
            return false;
        }
        if (context.getCurrentMode() != ToolMode.WRENCH) {
            return false;
        }
        BlockPos pos = context.getPos();
        BlockEntity tile = WorldUtils.getTileEntity((BlockGetter)level, (BlockPos)pos);
        if (tile == null) {
            return false;
        }
        Direction face = context.getFace();
        IConfigurable configurable = (IConfigurable)WorldUtils.getCapability((Level)level, (BlockCapability)Capabilities.CONFIGURABLE, (BlockPos)pos, null, (BlockEntity)tile, (Object)face);
        return configurable != null;
    }

    @Override
    public InteractionResult handle(WrenchContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        if (level == null || player == null || level.isClientSide()) {
            return InteractionResult.PASS;
        }
        BlockPos pos = context.getPos();
        BlockEntity tile = WorldUtils.getTileEntity((BlockGetter)level, (BlockPos)pos);
        if (tile == null) {
            return InteractionResult.PASS;
        }
        if (!IBlockSecurityUtils.INSTANCE.canAccessOrDisplayError(player, level, pos, tile)) {
            return InteractionResult.FAIL;
        }
        Direction face = context.getFace();
        IConfigurable configurable = (IConfigurable)WorldUtils.getCapability((Level)level, (BlockCapability)Capabilities.CONFIGURABLE, (BlockPos)pos, null, (BlockEntity)tile, (Object)face);
        if (configurable == null) {
            return InteractionResult.PASS;
        }
        return configurable.onSneakRightClick(player);
    }
}

