/*
 * Decompiled with CFR 0.152.
 */
package com.omnitools.omniTools.compat.extendedae;

import com.glodblock.github.extendedae.common.EAESingletons;
import com.glodblock.github.extendedae.common.me.wireless.WirelessFail;
import com.glodblock.github.extendedae.common.tileentities.TileWirelessConnector;
import com.glodblock.github.extendedae.common.tileentities.TileWirelessHub;
import com.glodblock.github.extendedae.config.EAEConfig;
import com.omnitools.omniTools.api.IWrenchHandler;
import com.omnitools.omniTools.api.WrenchContext;
import com.omnitools.omniTools.core.ToolMode;
import it.unimi.dsi.fastutil.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ExtendedAEWirelessWrenchHandler
implements IWrenchHandler {
    @Override
    public boolean canHandle(WrenchContext context) {
        if (context.getCurrentMode() != ToolMode.LINK) {
            return false;
        }
        Level level = context.getLevel();
        if (level == null) {
            return false;
        }
        BlockEntity be = level.getBlockEntity(context.getPos());
        return be instanceof TileWirelessConnector || be instanceof TileWirelessHub;
    }

    @Override
    public InteractionResult handle(WrenchContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ServerLevel server = (ServerLevel)level;
        BlockPos pos = context.getPos();
        BlockEntity be = level.getBlockEntity(pos);
        ItemStack stack = context.getStack();
        if (be instanceof TileWirelessConnector) {
            TileWirelessConnector connector = (TileWirelessConnector)be;
            return this.handleConnector(server, connector, pos, player, stack);
        }
        if (be instanceof TileWirelessHub) {
            TileWirelessHub hub = (TileWirelessHub)be;
            return this.handleHub(server, hub, pos, player, stack);
        }
        return InteractionResult.PASS;
    }

    private InteractionResult handleConnector(ServerLevel level, TileWirelessConnector tile, BlockPos thisPos, Player player, ItemStack stack) {
        Pair locator = (Pair)stack.get(EAESingletons.WIRELESS_LOCATOR);
        if (locator != null && (Long)locator.left() != 0L) {
            long freq = (Long)locator.left();
            GlobalPos globalPos = (GlobalPos)locator.right();
            if (globalPos == null) {
                player.displayClientMessage((Component)Component.translatable((String)"omnitools.compat.extendedae").append(" ").append(WirelessFail.MISSING.getTranslation()), true);
                return InteractionResult.SUCCESS;
            }
            BlockPos otherPos = globalPos.pos();
            ResourceKey otherDim = globalPos.dimension();
            ResourceKey thisDim = level.dimension();
            if (otherPos.equals((Object)thisPos) && otherDim.equals(thisDim)) {
                player.displayClientMessage((Component)Component.translatable((String)"omnitools.compat.extendedae").append(" ").append(WirelessFail.SELF_REFERENCE.getTranslation()), true);
                return InteractionResult.SUCCESS;
            }
            if (!otherDim.equals(thisDim)) {
                player.displayClientMessage((Component)Component.translatable((String)"omnitools.compat.extendedae").append(" ").append(WirelessFail.CROSS_DIMENSION.getTranslation()), true);
                return InteractionResult.SUCCESS;
            }
            if (Math.sqrt(otherPos.distSqr((Vec3i)thisPos)) > EAEConfig.wirelessMaxRange) {
                player.displayClientMessage((Component)Component.translatable((String)"omnitools.compat.extendedae").append(" ").append(WirelessFail.OUT_OF_RANGE.getTranslation()), true);
                return InteractionResult.SUCCESS;
            }
            ServerLevel otherWorld = level.getServer().getLevel(otherDim);
            if (otherWorld == null) {
                player.displayClientMessage((Component)Component.translatable((String)"omnitools.compat.extendedae").append(" ").append(WirelessFail.MISSING.getTranslation()), true);
                return InteractionResult.SUCCESS;
            }
            BlockEntity otherTile = otherWorld.getBlockEntity(otherPos);
            if (otherTile instanceof TileWirelessConnector) {
                TileWirelessConnector otherConnector = (TileWirelessConnector)otherTile;
                otherConnector.setFrequency(freq);
                tile.setFrequency(freq);
                stack.remove(EAESingletons.WIRELESS_LOCATOR);
                player.displayClientMessage((Component)Component.translatable((String)"omnitools.compat.extendedae").append(" ").append((Component)Component.translatable((String)"chat.wireless_connect", (Object[])new Object[]{thisPos.getX(), thisPos.getY(), thisPos.getZ()})), true);
                return InteractionResult.SUCCESS;
            }
            if (otherTile instanceof TileWirelessHub) {
                TileWirelessHub otherHub = (TileWirelessHub)otherTile;
                int port = otherHub.allocatePort();
                if (port < 0) {
                    player.displayClientMessage((Component)Component.translatable((String)"omnitools.compat.extendedae").append(" ").append(WirelessFail.OUT_OF_PORT.getTranslation()), true);
                    return InteractionResult.SUCCESS;
                }
                otherHub.setFrequency(freq, port);
                tile.setFrequency(freq);
                stack.remove(EAESingletons.WIRELESS_LOCATOR);
                player.displayClientMessage((Component)Component.translatable((String)"omnitools.compat.extendedae").append(" ").append((Component)Component.translatable((String)"chat.wireless_connect", (Object[])new Object[]{thisPos.getX(), thisPos.getY(), thisPos.getZ()})), true);
                return InteractionResult.SUCCESS;
            }
            player.displayClientMessage((Component)Component.translatable((String)"omnitools.compat.extendedae").append(" ").append(WirelessFail.MISSING.getTranslation()), true);
            return InteractionResult.SUCCESS;
        }
        long freq = tile.getNewFreq();
        GlobalPos globalPos = GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)thisPos);
        stack.set(EAESingletons.WIRELESS_LOCATOR, (Object)Pair.of((Object)freq, (Object)globalPos));
        player.displayClientMessage((Component)Component.translatable((String)"omnitools.compat.extendedae").append(" ").append((Component)Component.translatable((String)"chat.wireless_bind", (Object[])new Object[]{thisPos.getX(), thisPos.getY(), thisPos.getZ()})), true);
        return InteractionResult.SUCCESS;
    }

    private InteractionResult handleHub(ServerLevel level, TileWirelessHub tile, BlockPos thisPos, Player player, ItemStack stack) {
        Pair locator = (Pair)stack.get(EAESingletons.WIRELESS_LOCATOR);
        int port = tile.allocatePort();
        if (port < 0) {
            player.displayClientMessage((Component)Component.translatable((String)"omnitools.compat.extendedae").append(" ").append(WirelessFail.OUT_OF_PORT.getTranslation()), true);
            return InteractionResult.SUCCESS;
        }
        if (locator != null && (Long)locator.left() != 0L) {
            long freq = (Long)locator.left();
            GlobalPos globalPos = (GlobalPos)locator.right();
            if (globalPos == null) {
                player.displayClientMessage((Component)Component.translatable((String)"omnitools.compat.extendedae").append(" ").append(WirelessFail.MISSING.getTranslation()), true);
                return InteractionResult.SUCCESS;
            }
            BlockPos otherPos = globalPos.pos();
            ResourceKey otherDim = globalPos.dimension();
            ResourceKey thisDim = level.dimension();
            if (otherPos.equals((Object)thisPos) && otherDim.equals(thisDim)) {
                player.displayClientMessage((Component)Component.translatable((String)"omnitools.compat.extendedae").append(" ").append(WirelessFail.SELF_REFERENCE.getTranslation()), true);
                return InteractionResult.SUCCESS;
            }
            if (!otherDim.equals(thisDim)) {
                player.displayClientMessage((Component)Component.translatable((String)"omnitools.compat.extendedae").append(" ").append(WirelessFail.CROSS_DIMENSION.getTranslation()), true);
                return InteractionResult.SUCCESS;
            }
            if (Math.sqrt(otherPos.distSqr((Vec3i)thisPos)) > EAEConfig.wirelessMaxRange) {
                player.displayClientMessage((Component)Component.translatable((String)"omnitools.compat.extendedae").append(" ").append(WirelessFail.OUT_OF_RANGE.getTranslation()), true);
                return InteractionResult.SUCCESS;
            }
            ServerLevel otherWorld = level.getServer().getLevel(otherDim);
            if (otherWorld == null) {
                player.displayClientMessage((Component)Component.translatable((String)"omnitools.compat.extendedae").append(" ").append(WirelessFail.MISSING.getTranslation()), true);
                return InteractionResult.SUCCESS;
            }
            BlockEntity otherTile = otherWorld.getBlockEntity(otherPos);
            if (otherTile instanceof TileWirelessConnector) {
                TileWirelessConnector otherConnector = (TileWirelessConnector)otherTile;
                otherConnector.setFrequency(freq);
                tile.setFrequency(freq, port);
                player.displayClientMessage((Component)Component.translatable((String)"omnitools.compat.extendedae").append(" ").append((Component)Component.translatable((String)"chat.wireless_connect", (Object[])new Object[]{thisPos.getX(), thisPos.getY(), thisPos.getZ()})), true);
                return InteractionResult.SUCCESS;
            }
            if (otherTile instanceof TileWirelessHub) {
                TileWirelessHub otherHub = (TileWirelessHub)otherTile;
                int otherPort = otherHub.allocatePort();
                if (otherPort < 0) {
                    player.displayClientMessage((Component)Component.translatable((String)"omnitools.compat.extendedae").append(" ").append(WirelessFail.OUT_OF_PORT.getTranslation()), true);
                    return InteractionResult.SUCCESS;
                }
                otherHub.setFrequency(freq, otherPort);
                tile.setFrequency(freq, port);
                player.displayClientMessage((Component)Component.translatable((String)"omnitools.compat.extendedae").append(" ").append((Component)Component.translatable((String)"chat.wireless_connect", (Object[])new Object[]{thisPos.getX(), thisPos.getY(), thisPos.getZ()})), true);
                return InteractionResult.SUCCESS;
            }
            player.displayClientMessage((Component)Component.translatable((String)"omnitools.compat.extendedae").append(" ").append(WirelessFail.MISSING.getTranslation()), true);
            return InteractionResult.SUCCESS;
        }
        long freq = tile.getNewFreq();
        GlobalPos globalPos = GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)thisPos);
        stack.set(EAESingletons.WIRELESS_LOCATOR, (Object)Pair.of((Object)freq, (Object)globalPos));
        player.displayClientMessage((Component)Component.translatable((String)"omnitools.compat.extendedae").append(" ").append((Component)Component.translatable((String)"chat.wireless_bind", (Object[])new Object[]{thisPos.getX(), thisPos.getY(), thisPos.getZ()})), true);
        return InteractionResult.SUCCESS;
    }
}

