/*
 * Decompiled with CFR 0.152.
 */
package com.omnitools.omniTools.client;

import com.mojang.blaze3d.platform.InputConstants;
import com.omnitools.omniTools.compat.entangled.EntangledHighlightHandler;
import com.omnitools.omniTools.core.ModItems;
import com.omnitools.omniTools.core.OmniToolItem;
import com.omnitools.omniTools.core.ToolMode;
import com.omnitools.omniTools.network.SyncToolModePacket;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="omnitools", value={Dist.CLIENT})
public class ClientEvents {
    public static KeyMapping CYCLE_MODE_KEYBIND;

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemProperties.register((Item)((Item)ModItems.OMNI_WRENCH.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"omnitools", (String)"mode"), (stack, level, entity, seed) -> {
                ToolMode mode = OmniToolItem.getMode(stack);
                if (mode == ToolMode.LINK) {
                    return 1.0f;
                }
                if (mode == ToolMode.RENAME) {
                    return 2.0f;
                }
                return 0.0f;
            });
            if (ModList.get().isLoaded("entangled")) {
                NeoForge.EVENT_BUS.addListener(EntangledHighlightHandler::onRenderWorld);
            }
        });
    }

    @SubscribeEvent
    public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        CYCLE_MODE_KEYBIND = new KeyMapping("key.omnitools.cycle_mode", InputConstants.Type.KEYSYM, 342, "key.categories.omnitools");
        event.register(CYCLE_MODE_KEYBIND);
    }

    @EventBusSubscriber(modid="omnitools", value={Dist.CLIENT})
    public static class GameEvents {
        @SubscribeEvent
        public static void onClientTick(ClientTickEvent.Pre event) {
            Minecraft mc = Minecraft.getInstance();
            LocalPlayer player = mc.player;
            if (player != null && mc.screen == null) {
                while (CYCLE_MODE_KEYBIND != null && CYCLE_MODE_KEYBIND.consumeClick()) {
                    ItemStack mainHandStack = player.getMainHandItem();
                    if (mainHandStack.getItem() != ModItems.OMNI_WRENCH.get()) continue;
                    ToolMode oldMode = OmniToolItem.getMode(mainHandStack);
                    OmniToolItem.cycleMode(mainHandStack);
                    ToolMode newMode = OmniToolItem.getMode(mainHandStack);
                    PacketDistributor.sendToServer((CustomPacketPayload)new SyncToolModePacket(newMode.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    player.displayClientMessage((Component)Component.translatable((String)"message.omnitools.mode_switched", (Object[])new Object[]{Component.translatable((String)newMode.getTranslationKey())}), true);
                }
            }
        }
    }
}

