/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.network.messages;

import com.klikli_dev.occultism.network.IMessage;
import com.klikli_dev.occultism.registry.OccultismDataStorage;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class MessageSetJumps
implements IMessage {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"set_jumps");
    public static final CustomPacketPayload.Type<MessageSetJumps> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, MessageSetJumps> STREAM_CODEC = CustomPacketPayload.codec(MessageSetJumps::encode, MessageSetJumps::new);
    public int jumps;

    public MessageSetJumps(RegistryFriendlyByteBuf buf) {
        this.decode(buf);
    }

    public MessageSetJumps(int jumps) {
        this.jumps = jumps;
    }

    @Override
    public void onClientReceived(Minecraft minecraft, Player player) {
        if (!player.onGround()) {
            player.setData(OccultismDataStorage.DOUBLE_JUMP, (Object)this.jumps);
        }
    }

    @Override
    public void encode(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.jumps);
    }

    @Override
    public void decode(RegistryFriendlyByteBuf buf) {
        this.jumps = buf.readInt();
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

