/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.item.storage;

import com.klikli_dev.occultism.registry.OccultismDataComponents;
import com.klikli_dev.occultism.registry.OccultismItems;
import com.klikli_dev.occultism.registry.OccultismSounds;
import com.klikli_dev.occultism.util.ItemNBTUtil;
import com.klikli_dev.occultism.util.TextUtil;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class EnderSatchelItem
extends Item {
    public EnderSatchelItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (player.isShiftKeyDown()) {
                if (ItemNBTUtil.getLikedPlayerName(stack) == null) {
                    ItemNBTUtil.setLikedPlayerName(stack, player.getName().getString());
                    ItemNBTUtil.setLinkedPlayerUUID(stack, serverPlayer.getUUID());
                    level.playSound(null, player.blockPosition(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 1.0f, 4.0f);
                } else {
                    ItemNBTUtil.setLikedPlayerName(stack, null);
                    ItemNBTUtil.setLinkedPlayerUUID(stack, null);
                    level.playSound(null, player.blockPosition(), OccultismSounds.POOF.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            } else {
                String name = player.getName().getString();
                PlayerEnderChestContainer enderChestContainer = player.getEnderChestInventory();
                if (stack.has(OccultismDataComponents.LINKED_PLAYER_UUID)) {
                    UUID playerLinkedUUID = ItemNBTUtil.getLinkedPlayerUUID(stack);
                    name = ItemNBTUtil.getLikedPlayerName(stack);
                    if (playerLinkedUUID != null) {
                        for (ServerLevel eachLvl : Objects.requireNonNull(level.getServer()).getAllLevels()) {
                            Entity entity = eachLvl.getEntity(playerLinkedUUID);
                            if (!(entity instanceof Player)) continue;
                            Player playerLinked = (Player)entity;
                            enderChestContainer = playerLinked.getEnderChestInventory();
                            break;
                        }
                    }
                }
                PlayerEnderChestContainer finalEnderChestContainer = enderChestContainer;
                player.openMenu((MenuProvider)new SimpleMenuProvider((p_53124_, p_53125_, p_53126_) -> ChestMenu.threeRows((int)p_53124_, (Inventory)p_53125_, (Container)finalEnderChestContainer), (Component)Component.translatable((String)(((EnderSatchelItem)((Object)OccultismItems.ENDER_SATCHEL.get())).getDescriptionId() + ".chest_menu"), (Object[])new Object[]{name})));
                player.awardStat(Stats.OPEN_ENDERCHEST);
                level.playSound(null, player.blockPosition(), SoundEvents.ENDER_CHEST_OPEN, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public void appendHoverText(@NotNull ItemStack pStack, @NotNull Item.TooltipContext pContext, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pTooltipFlag) {
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
        pTooltipComponents.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip"), (Object[])new Object[]{TextUtil.formatDemonName(ItemNBTUtil.getBoundSpiritName(pStack))}));
        if (ItemNBTUtil.getLikedPlayerName(pStack) != null) {
            pTooltipComponents.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip_linked"), (Object[])new Object[]{TextUtil.formatPlayerName(ItemNBTUtil.getLikedPlayerName(pStack))}));
        }
    }

    public boolean isFoil(@NotNull ItemStack stack) {
        return ItemNBTUtil.getLikedPlayerName(stack) != null;
    }
}

