/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.render.entity;

import com.klikli_dev.occultism.client.model.entity.MummyFamiliarModel;
import com.klikli_dev.occultism.common.entity.familiar.MummyFamiliarEntity;
import com.klikli_dev.occultism.registry.OccultismModelLayers;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import software.bernie.geckolib.util.Color;

public class MummyFamiliarRenderer
extends MobRenderer<MummyFamiliarEntity, MummyFamiliarModel> {
    private static final ResourceLocation TEXTURES = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"textures/entity/mummy_familiar.png");

    public MummyFamiliarRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new MummyFamiliarModel(context.bakeLayer(OccultismModelLayers.FAMILIAR_MUMMY)), 0.3f);
        this.addLayer(new KapowLayer(this, context));
        this.addLayer(new EyesLayer((RenderLayerParent<MummyFamiliarEntity, MummyFamiliarModel>)this));
    }

    public ResourceLocation getTextureLocation(MummyFamiliarEntity entity) {
        return TEXTURES;
    }

    private static class KapowLayer
    extends RenderLayer<MummyFamiliarEntity, MummyFamiliarModel> {
        private static final ResourceLocation KAPOW_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"textures/entity/kapow.png");
        private static final Component KAPOW_TEXT = Component.translatable((String)"dialog.occultism.mummy.kapow");
        private static KapowModel model;
        private final MummyFamiliarRenderer renderer;

        public KapowLayer(MummyFamiliarRenderer renderer, EntityRendererProvider.Context context) {
            super((RenderLayerParent)renderer);
            this.renderer = renderer;
            if (model == null) {
                model = new KapowModel(context.bakeLayer(OccultismModelLayers.KAPOW));
            }
        }

        public void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, MummyFamiliarEntity pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
            if (pLivingEntity.getFightPose() == -1) {
                return;
            }
            float alpha = pLivingEntity.getCapowAlpha(pPartialTicks);
            pMatrixStack.pushPose();
            float scale = 0.5f;
            pMatrixStack.scale(scale, scale, scale);
            Vec3 capowPos = pLivingEntity.getCapowPosition(pPartialTicks);
            pMatrixStack.translate(capowPos.x, -0.4 + capowPos.y, capowPos.z);
            model.renderToBuffer(pMatrixStack, pBuffer.getBuffer(model.renderType(KAPOW_TEXTURE)), pPackedLight, OverlayTexture.NO_OVERLAY, Color.ofRGBA((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha).getColor());
            pMatrixStack.pushPose();
            pMatrixStack.scale(0.07f, 0.07f, 0.07f);
            pMatrixStack.translate(0.0, -2.5, 0.0);
            pMatrixStack.mulPose(new Quaternionf().rotateXYZ(0.0f, 0.0f, 0.34906584f));
            Font font = this.renderer.getFont();
            pMatrixStack.pushPose();
            pMatrixStack.translate(0.0, 0.0, -0.01);
            Matrix4f matrix = pMatrixStack.last().pose();
            font.drawInBatch(KAPOW_TEXT, (float)(-font.width((FormattedText)KAPOW_TEXT) / 2), 0.0f, 0xFF0000 | (int)(alpha * 255.0f) << 24, true, matrix, pBuffer, Font.DisplayMode.NORMAL, 0, pPackedLight);
            pMatrixStack.popPose();
            pMatrixStack.pushPose();
            pMatrixStack.translate(0.0, 0.0, 0.01);
            pMatrixStack.mulPose(new Quaternionf().rotateXYZ(0.0f, (float)Math.PI, 0.0f));
            matrix = pMatrixStack.last().pose();
            font.drawInBatch(KAPOW_TEXT, (float)(-font.width((FormattedText)KAPOW_TEXT) / 2), 0.0f, 0xFF0000 | (int)(alpha * 255.0f) << 24, true, matrix, pBuffer, Font.DisplayMode.NORMAL, 0, pPackedLight);
            pMatrixStack.popPose();
            pMatrixStack.popPose();
            pMatrixStack.popPose();
        }
    }

    private static class EyesLayer
    extends RenderLayer<MummyFamiliarEntity, MummyFamiliarModel> {
        private static final ResourceLocation EYES = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"textures/entity/mummy_familiar_eyes.png");

        public EyesLayer(RenderLayerParent<MummyFamiliarEntity, MummyFamiliarModel> parent) {
            super(parent);
        }

        public void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, MummyFamiliarEntity pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float ppPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
            if (pLivingEntity.isInvisible()) {
                return;
            }
            int light = pLivingEntity.isSitting() ? 0 : 10;
            MummyFamiliarModel model = (MummyFamiliarModel)this.getParentModel();
            VertexConsumer ivertexbuilder = pBuffer.getBuffer(RenderType.entityCutout((ResourceLocation)EYES));
            model.renderToBuffer(pMatrixStack, ivertexbuilder, LightTexture.pack((int)light, (int)light), LivingEntityRenderer.getOverlayCoords((LivingEntity)pLivingEntity, (float)0.0f));
        }
    }

    public static class KapowModel
    extends Model {
        public ModelPart kapow;

        public KapowModel(ModelPart part) {
            super(RenderType::entityTranslucent);
            this.kapow = part.getChild("kapow");
        }

        public static LayerDefinition createBodyLayer() {
            MeshDefinition mesh = new MeshDefinition();
            PartDefinition parts = mesh.getRoot();
            PartDefinition body = parts.addOrReplaceChild("kapow", CubeListBuilder.create().texOffs(0, 0).addBox(-16.0f, -16.0f, 0.0f, 32.0f, 32.0f, 0.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
            return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)32);
        }

        public void renderToBuffer(PoseStack pPoseStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, int pColor) {
            this.kapow.render(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pColor);
        }
    }
}

