/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.content.pentacleschematics;

import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.klikli_dev.modonomicon.api.multiblock.StateMatcher;
import com.klikli_dev.modonomicon.data.MultiblockDataManager;
import com.klikli_dev.modonomicon.multiblock.matcher.TagMatcher;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.simibubi.create.AllDataComponents;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import io.github.irishgreencitrus.occultengineering.OccultEngineering;
import io.github.irishgreencitrus.occultengineering.content.pentacleschematics.BlockTagRequirement;
import io.github.irishgreencitrus.occultengineering.content.pentacleschematics.PentaclePrinter;
import io.github.irishgreencitrus.occultengineering.mixin.accessor.TagMatcherAccessor;
import io.github.irishgreencitrus.occultengineering.registry.OccultEngineeringDataComponents;
import io.github.irishgreencitrus.occultengineering.registry.OccultEngineeringItems;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class PentacleSchematic {
    private final Multiblock pentacle;
    private final Level level;
    public final BlockPos position;
    private Pair<BlockPos, Collection<Multiblock.SimulateResult>> simulationResults;

    @NotNull
    public static Either<PentacleSchematic, ParseResult> fromStack(Level level, ItemStack stack) {
        if (!OccultEngineeringItems.PENTACLE_SCHEMATIC.isIn(stack)) {
            return Either.right((Object)((Object)ParseResult.NOT_PENTACLE_SCHEMATIC));
        }
        List<DataComponentType<Vec3i>> requiredDataComponents = List.of(AllDataComponents.SCHEMATIC_DEPLOYED, OccultEngineeringDataComponents.PENTSCHEM_RESOURCE_LOCATION, AllDataComponents.SCHEMATIC_ANCHOR, OccultEngineeringDataComponents.PENTSCHEM_BOUNDS);
        if (!requiredDataComponents.stream().allMatch(arg_0 -> ((ItemStack)stack).has(arg_0))) {
            return Either.right((Object)((Object)ParseResult.NO_TAG));
        }
        Boolean hasDeployed = (Boolean)stack.get(AllDataComponents.SCHEMATIC_DEPLOYED);
        if (!Boolean.TRUE.equals(hasDeployed)) {
            return Either.right((Object)((Object)ParseResult.NOT_DEPLOYED));
        }
        ResourceLocation pentacleResource = (ResourceLocation)stack.get(OccultEngineeringDataComponents.PENTSCHEM_RESOURCE_LOCATION);
        if (pentacleResource == null) {
            return Either.right((Object)((Object)ParseResult.INVALID_PENTACLE_NAME));
        }
        Multiblock multiblock = MultiblockDataManager.get().getMultiblock(pentacleResource);
        if (multiblock == null) {
            return Either.right((Object)((Object)ParseResult.INVALID_PENTACLE_MULTIBLOCK));
        }
        BlockPos pentaclePos = (BlockPos)stack.get(AllDataComponents.SCHEMATIC_ANCHOR);
        return Either.left((Object)new PentacleSchematic(level, multiblock, pentaclePos));
    }

    public PentacleSchematic(Level level, Multiblock pentacle, BlockPos position) {
        this.pentacle = pentacle;
        this.level = level;
        this.position = position;
    }

    public Level getLevel() {
        return this.level;
    }

    public void populateSimulation() {
        Pair results = this.pentacle.simulate(this.level, this.position, Rotation.NONE, false, false);
        this.simulationResults = Pair.of((Object)((BlockPos)results.getFirst()), ((Collection)results.getSecond()).stream().filter(i -> i.getStateMatcher().countsTowardsTotalBlocks()).toList());
    }

    public Pair<BlockPos, Collection<Multiblock.SimulateResult>> getCurrentSimulationResult() {
        this.populateSimulation();
        return this.simulationResults;
    }

    public ItemRequirement getItemRequirement() {
        ItemRequirement itemRequirement = ItemRequirement.NONE;
        if (this.simulationResults == null || ((Collection)this.simulationResults.getSecond()).isEmpty()) {
            this.populateSimulation();
        }
        if (((Collection)this.simulationResults.getSecond()).isEmpty()) {
            OccultEngineering.LOGGER.warn("Empty multiblock encountered");
            return ItemRequirement.INVALID;
        }
        for (Multiblock.SimulateResult r : (Collection)this.simulationResults.getSecond()) {
            BlockState targetState = r.getStateMatcher().getDisplayedState(this.level.getGameTime());
            StateMatcher stateMatcher = r.getStateMatcher();
            if (stateMatcher instanceof TagMatcher) {
                TagMatcher tagMatcher = (TagMatcher)stateMatcher;
                TagMatcherAccessor tagAccess = (TagMatcherAccessor)tagMatcher;
                BlockTagRequirement tagRequirement = new BlockTagRequirement(new ItemStack((ItemLike)tagMatcher.getDisplayedState(this.level.getGameTime()).getBlock()), tagAccess.getTag().get());
                itemRequirement = itemRequirement.union(new ItemRequirement((ItemRequirement.StackRequirement)tagRequirement));
                continue;
            }
            ItemRequirement requirement = ItemRequirement.of((BlockState)targetState, null);
            itemRequirement = itemRequirement.union(requirement);
        }
        return itemRequirement;
    }

    public void instantPlace() {
        PentaclePrinter printer = new PentaclePrinter();
        printer.initialise(this);
        if (printer.isInitialised()) {
            printer.placeAll();
        }
    }

    public static enum ParseResult {
        OK,
        NOT_PENTACLE_SCHEMATIC,
        NO_TAG,
        INVALID_TAG,
        NOT_DEPLOYED,
        INVALID_PENTACLE_NAME,
        INVALID_PENTACLE_MULTIBLOCK;

    }
}

