/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus.occultengineering.content.item;

import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.client.gui.book.BookAddress;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.item.ModonomiconItem;
import com.mojang.serialization.DynamicOps;
import io.github.irishgreencitrus.occultengineering.OccultEngineering;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MechanicalGuideItem
extends ModonomiconItem {
    public static ResourceLocation ENCYCLOPEDIA_OF_SOULS = OccultEngineering.asResource("encyclopedia_of_souls");

    public MechanicalGuideItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        Book book;
        ItemStack itemInHand = pPlayer.getItemInHand(pUsedHand);
        if (pLevel.isClientSide && (book = BookDataManager.get().getBook(ENCYCLOPEDIA_OF_SOULS)) != null) {
            OccultEngineering.LOGGER.info("Opening book: {} -> {}", (Object)book.getId(), (Object)book.getName());
            BookGuiManager.get().openBook(BookAddress.defaultFor((Book)book));
        }
        return InteractionResultHolder.sidedSuccess((Object)itemInHand, (boolean)pLevel.isClientSide);
    }

    public Component getName(ItemStack pStack) {
        Book book = BookDataManager.get().getBook(ENCYCLOPEDIA_OF_SOULS);
        if (book != null) {
            return Component.translatable((String)book.getName());
        }
        return super.getName(pStack);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        Book book = BookDataManager.get().getBook(ENCYCLOPEDIA_OF_SOULS);
        if (book != null) {
            if (tooltipFlag.isAdvanced()) {
                tooltip.add((Component)Component.literal((String)"Book ID: ").withStyle(ChatFormatting.DARK_GRAY).append((Component)Component.literal((String)book.getId().toString()).withStyle(ChatFormatting.RED)));
            }
            if (!book.getTooltip().isBlank()) {
                tooltip.add((Component)Component.translatable((String)book.getTooltip()).withStyle(ChatFormatting.GRAY));
            }
        } else {
            CompoundTag compoundTag = new CompoundTag();
            for (TypedDataComponent entry : itemStack.getComponents()) {
                Tag tag = (Tag)entry.encodeValue((DynamicOps)Objects.requireNonNull(tooltipContext.registries()).createSerializationContext((DynamicOps)NbtOps.INSTANCE)).getOrThrow();
                ResourceLocation key = BuiltInRegistries.DATA_COMPONENT_TYPE.getKey((Object)entry.type());
                assert (key != null);
                compoundTag.put(key.toString(), tag);
            }
            tooltip.add((Component)Component.translatable((String)"tooltip.modonomicon.no_book_found_for_stack", (Object[])new Object[]{NbtUtils.toPrettyComponent((Tag)compoundTag)}).withStyle(ChatFormatting.DARK_GRAY));
        }
    }
}

