/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.soldering;

import commoble.morered.soldering.SolderingMenu;
import commoble.morered.soldering.SolderingRecipe;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.Nullable;

public class SolderingResultSlot
extends Slot {
    private final SolderingMenu container;

    public SolderingResultSlot(SolderingMenu container, Container resultInventory, int index, int xPosition, int yPosition) {
        super(resultInventory, index, xPosition, yPosition);
        this.container = container;
    }

    public boolean mayPlace(ItemStack stack) {
        return false;
    }

    public void onTake(Player player, ItemStack stack) {
        super.onTake(player, stack);
        if (this.container.currentRecipe != null) {
            this.removeIngredients(player.getInventory(), this.container.currentRecipe);
        }
        this.verifyRecipeAfterCrafting(player.getInventory(), this.container.currentRecipe);
    }

    public boolean mayPickup(Player player) {
        return this.container.currentRecipe != null;
    }

    public void removeIngredients(Inventory playerInventory, SolderingRecipe recipe) {
        List<SizedIngredient> ingredients = recipe.ingredients();
        for (SizedIngredient ingredient : ingredients) {
            int remainingItemsToRemove = ingredient.count();
            int playerSlots = playerInventory.getContainerSize();
            for (int playerSlot = 0; playerSlot < playerSlots && remainingItemsToRemove > 0; ++playerSlot) {
                ItemStack stackInSlot = playerInventory.getItem(playerSlot);
                if (!ingredient.test(stackInSlot)) continue;
                int decrementAmount = Math.min(remainingItemsToRemove, stackInSlot.getCount());
                remainingItemsToRemove -= decrementAmount;
                playerInventory.removeItem(playerSlot, decrementAmount);
            }
        }
    }

    public void verifyRecipeAfterCrafting(Inventory playerInventory, @Nullable SolderingRecipe recipe) {
        if (recipe != null && SolderingRecipe.doesPlayerHaveIngredients(playerInventory, recipe)) {
            this.set(recipe.getResultItem((HolderLookup.Provider)playerInventory.player.level().registryAccess()).copy());
            this.container.currentRecipe = recipe;
        } else {
            this.set(ItemStack.EMPTY);
            this.container.currentRecipe = null;
        }
    }
}

