/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.api.internal;

import com.google.common.collect.ImmutableMap;
import commoble.morered.api.ExpandedPowerSupplier;
import commoble.morered.api.WireConnector;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.level.block.Block;

public class APIRegistries {
    private static Map<Block, WireConnector> wireConnectabilities = new ConcurrentHashMap<Block, WireConnector>();
    private static Map<Block, ExpandedPowerSupplier> expandedPowerSuppliers = new ConcurrentHashMap<Block, ExpandedPowerSupplier>();
    private static Map<Block, WireConnector> cableConnectabilities = new ConcurrentHashMap<Block, WireConnector>();

    public static Map<Block, WireConnector> getWireConnectabilities() {
        return wireConnectabilities;
    }

    public static Map<Block, ExpandedPowerSupplier> getExpandedPowerSuppliers() {
        return expandedPowerSuppliers;
    }

    public static Map<Block, WireConnector> getCableConnectabilities() {
        return cableConnectabilities;
    }

    public static void freezeRegistries() {
        wireConnectabilities = APIRegistries.freezeAPIRegistry(wireConnectabilities);
        expandedPowerSuppliers = APIRegistries.freezeAPIRegistry(expandedPowerSuppliers);
        cableConnectabilities = APIRegistries.freezeAPIRegistry(cableConnectabilities);
    }

    private static <K, V> Map<K, V> freezeAPIRegistry(Map<K, V> mutableRegistry) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        mutableRegistry.forEach((arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        return builder.build();
    }
}

