/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.mixin.enchanting;

import com.almostreliable.morejs.Debug;
import com.almostreliable.morejs.MoreJS;
import com.almostreliable.morejs.core.Events;
import com.almostreliable.morejs.features.enchantment.EnchantmentMenuExtension;
import com.almostreliable.morejs.features.enchantment.EnchantmentMenuState;
import com.almostreliable.morejs.features.enchantment.EnchantmentState;
import com.almostreliable.morejs.features.enchantment.EnchantmentTableServerEventJS;
import com.almostreliable.morejs.features.enchantment.IsEnchantableEventJS;
import com.almostreliable.morejs.features.enchantment.PlayerEnchantEventJS;
import com.llamalad7.mixinextras.sugar.Local;
import dev.latvian.mods.kubejs.event.KubeEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EnchantmentMenu.class}, priority=42)
public abstract class EnchantmentMenuMixin
extends AbstractContainerMenu
implements EnchantmentMenuExtension {
    @Nullable
    @Unique
    private EnchantmentMenuState morejs$state;
    @Shadow
    @Final
    private Container enchantSlots;
    @Shadow
    @Final
    private ContainerLevelAccess access;
    @Shadow
    @Final
    private RandomSource random;
    @Shadow
    @Final
    public int[] costs;
    @Shadow
    @Final
    public int[] enchantClue;
    @Shadow
    @Final
    public int[] levelClue;

    protected EnchantmentMenuMixin(@Nullable MenuType<?> menuType, int i) {
        super(menuType, i);
    }

    @Override
    public Optional<EnchantmentMenuState> morejs$getState() {
        return Optional.ofNullable(this.morejs$state);
    }

    @Override
    public Container morejs$getContainer() {
        return this.enchantSlots;
    }

    @Override
    public int[] morejs$getCosts() {
        return this.costs;
    }

    @Override
    public int[] morejs$getEnchantmentClues() {
        return this.enchantClue;
    }

    @Override
    public int[] morejs$getLevelClues() {
        return this.levelClue;
    }

    @Override
    public RandomSource morejs$getRandom() {
        return this.random;
    }

    @Inject(method={"<init>(ILnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/world/inventory/ContainerLevelAccess;)V"}, at={@At(value="RETURN")})
    private void initializeProcess(int i, Inventory inventory, ContainerLevelAccess containerLevelAccess, CallbackInfo ci) {
        if (inventory.player instanceof ServerPlayer) {
            this.morejs$state = new EnchantmentMenuState((EnchantmentMenu)this, inventory.player);
        }
    }

    @Inject(method={"slotsChanged"}, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/Container;getItem(I)Lnet/minecraft/world/item/ItemStack;", shift=At.Shift.AFTER)}, cancellable=true)
    private void slotchanged$PrepareChangeEvent(Container inventory, CallbackInfo ci, @Local ItemStack item) {
        this.morejs$getState().ifPresent(state -> {
            if (state.matchesCurrentItem(item)) {
                ci.cancel();
                return;
            }
            if (item.isEmpty()) {
                state.reset(item);
                return;
            }
            state.prepareEvent(item);
        });
    }

    @Redirect(method={"slotsChanged"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isEnchantable()Z"))
    private boolean slotChanged$InvokeEnchantableEvent(ItemStack itemStack, Container container) {
        EnchantmentMenuState ems = this.morejs$getState().orElse(null);
        if (ems == null) {
            return itemStack.isEnchantable();
        }
        MutableBoolean enchantable = new MutableBoolean(itemStack.isEnchantable());
        this.access.execute((level, pos) -> {
            if (Debug.ENCHANTMENT) {
                MoreJS.LOG.warn("Invoke 'isEnchantable' event for item <{}> with player <{}>", (Object)itemStack, (Object)ems.getPlayer());
            }
            ItemStack secondItem = container.getItem(1);
            IsEnchantableEventJS e = new IsEnchantableEventJS(itemStack, secondItem, (Level)level, (BlockPos)pos, ems, enchantable);
            Events.IS_ENCHANTABLE.post((KubeEvent)e);
        });
        return ems.storeItemIsEnchantable(enchantable.booleanValue());
    }

    @Inject(method={"lambda$slotsChanged$0"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/inventory/EnchantmentMenu;broadcastChanges()V")})
    private void morejs$invokeChangeEvent(ItemStack item, Level level, BlockPos pos, CallbackInfo ci) {
        this.morejs$getState().ifPresent(state -> {
            if (Debug.ENCHANTMENT) {
                MoreJS.LOG.warn("Invoke 'enchantmentTableChanged' event for item <{}> with player <{}>", (Object)item, (Object)state.getPlayer());
            }
            ItemStack secondItem = this.enchantSlots.getItem(1);
            state.setState(EnchantmentState.USE_STORED_ENCHANTMENTS);
            Events.ENCHANTMENT_TABLE_CHANGED.post((KubeEvent)new EnchantmentTableServerEventJS(item, secondItem, level, pos, state.getPlayer(), (EnchantmentMenuState)state));
        });
    }

    @Inject(method={"getEnchantmentList"}, at={@At(value="RETURN")}, cancellable=true)
    private void handleEnchantmentGetter(RegistryAccess registryAccess, ItemStack itemStack, int index, int powerLevel, CallbackInfoReturnable<List<EnchantmentInstance>> cir) {
        this.morejs$getState().ifPresent(state -> {
            switch (state.getState()) {
                case STORE_ENCHANTMENTS: {
                    state.setEnchantments(index, (List)cir.getReturnValue());
                    break;
                }
                case USE_STORED_ENCHANTMENTS: {
                    ArrayList<EnchantmentInstance> enchantments = new ArrayList<EnchantmentInstance>(state.getEnchantments(index));
                    cir.setReturnValue(enchantments);
                }
            }
        });
    }

    @Inject(method={"lambda$clickMenuButton$1"}, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/inventory/EnchantmentMenu;getEnchantmentList(Lnet/minecraft/core/RegistryAccess;Lnet/minecraft/world/item/ItemStack;II)Ljava/util/List;", shift=At.Shift.AFTER)}, cancellable=true)
    private void morejs$invokeEnchantmentTableEnchant(ItemStack mainItem, int btnRow, Player player, int minLevel, ItemStack secondItem, Level level, BlockPos pos, CallbackInfo ci, @Local List<EnchantmentInstance> enchantments) {
        this.morejs$getState().ifPresent(state -> {
            if (player != state.getPlayer()) {
                MoreJS.LOG.error("<{}> Player changed during clickMenuButton", (Object)state.getPlayer());
                return;
            }
            int requiredLevel = state.getMenu().costs[btnRow];
            PlayerEnchantEventJS e = new PlayerEnchantEventJS(mainItem, secondItem, level, pos, player, (EnchantmentMenuState)state, requiredLevel, enchantments);
            if (Events.ENCHANTMENT_TABLE_ENCHANT.post((KubeEvent)e).interruptFalse()) {
                ci.cancel();
                return;
            }
            state.reset(ItemStack.EMPTY);
        });
    }
}

