/*
 * Decompiled with CFR 0.152.
 */
package com.tom.morewires.compat.cc;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.blocks.generic.ConnectorBlock;
import com.tom.morewires.MoreImmersiveWires;
import com.tom.morewires.compat.cc.CCBlockEntity;
import com.tom.morewires.compat.cc.CCModemConnectorBlockEntity;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemFullBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.registries.DeferredHolder;

public class CCModemConnectorBlock
extends ConnectorBlock<CCModemConnectorBlockEntity> {
    public CCModemConnectorBlock(DeferredHolder<BlockEntityType<?>, BlockEntityType<BlockEntity>> entityType) {
        super((BlockBehaviour.Properties)ConnectorBlock.PROPERTIES.get(), entityType);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{IEProperties.FACING_ALL, BlockStateProperties.WATERLOGGED, WiredModemFullBlock.MODEM_ON, WiredModemFullBlock.PERIPHERAL_ON});
    }

    public final void onRemove(BlockState block, Level world, BlockPos pos, BlockState replace, boolean bool) {
        if (block.getBlock() == replace.getBlock()) {
            return;
        }
        BlockEntity tile = world.getBlockEntity(pos);
        super.onRemove(block, world, pos, replace, bool);
        world.removeBlockEntity(pos);
        if (tile instanceof CCBlockEntity) {
            CCBlockEntity generic = (CCBlockEntity)tile;
            generic.destroy();
        }
    }

    public ItemInteractionResult useItemOn(ItemStack arg0, BlockState arg1, Level arg2, BlockPos arg3, Player player, InteractionHand hand, BlockHitResult arg6) {
        if (player.getItemInHand(hand).is((Item)MoreImmersiveWires.CC_WIRE.simple().COIL.get())) {
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        return super.useItemOn(arg0, arg1, arg2, arg3, player, hand, arg6);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        InteractionResult interactionResult;
        BlockEntity tile = level.getBlockEntity(pos);
        if (tile instanceof CCModemConnectorBlockEntity) {
            CCModemConnectorBlockEntity generic = (CCModemConnectorBlockEntity)tile;
            interactionResult = generic.use(player);
        } else {
            interactionResult = InteractionResult.PASS;
        }
        return interactionResult;
    }

    public final void neighborChanged(BlockState state, Level world, BlockPos pos, Block neighbourBlock, BlockPos neighbourPos, boolean isMoving) {
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof CCBlockEntity) {
            CCBlockEntity generic = (CCBlockEntity)tile;
            generic.onNeighbourChange(neighbourPos);
        }
    }

    public final void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos neighbour) {
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof CCBlockEntity) {
            CCBlockEntity generic = (CCBlockEntity)tile;
            generic.onNeighbourTileEntityChange(neighbour);
        }
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        BlockEntity te = world.getBlockEntity(pos);
        if (te instanceof CCBlockEntity) {
            CCBlockEntity generic = (CCBlockEntity)te;
            generic.blockTick();
        }
    }
}

