/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.moofluids.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.portingdeadmods.moofluids.recipe.AlloyRecipeInput;
import com.portingdeadmods.moofluids.recipe.MFRecipes;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;

public record AlloyRecipe(List<Fluid> inputs, Fluid output, float successChance) implements Recipe<AlloyRecipeInput>
{
    public boolean matches(AlloyRecipeInput input, Level level) {
        if (input.fluids().size() != this.inputs.size()) {
            return false;
        }
        List<Fluid> inputFluids = input.fluids().stream().sorted(Comparator.comparing(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.FLUID).getKey(arg_0))).toList();
        List<Fluid> recipeFluids = this.inputs.stream().sorted(Comparator.comparing(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.FLUID).getKey(arg_0))).toList();
        return inputFluids.equals(recipeFluids);
    }

    public ItemStack assemble(AlloyRecipeInput input, HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)MFRecipes.ALLOY_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)MFRecipes.ALLOY_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<AlloyRecipe> {
        public static final MapCodec<AlloyRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.FLUID.byNameCodec().listOf().fieldOf("inputs").forGetter(AlloyRecipe::inputs), (App)BuiltInRegistries.FLUID.byNameCodec().fieldOf("output").forGetter(AlloyRecipe::output), (App)ExtraCodecs.POSITIVE_FLOAT.optionalFieldOf("success_chance", (Object)Float.valueOf(1.0f)).forGetter(AlloyRecipe::successChance)).apply((Applicative)instance, AlloyRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, AlloyRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.collection(ArrayList::new, (StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.FLUID)), AlloyRecipe::inputs, (StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.FLUID), AlloyRecipe::output, (StreamCodec)ByteBufCodecs.FLOAT, AlloyRecipe::successChance, AlloyRecipe::new);

        public MapCodec<AlloyRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, AlloyRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

