/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.moofluids.compat.jei;

import com.portingdeadmods.moofluids.compat.jei.AlchemyGlassJeiHandler;
import com.portingdeadmods.moofluids.compat.jei.FluidBreedingRecipeManagerPlugin;
import com.portingdeadmods.moofluids.compat.jei.FluidCowBreedingCategory;
import com.portingdeadmods.moofluids.compat.jei.FluidCowBreedingRecipe;
import com.portingdeadmods.moofluids.compat.jei.FluidCowBreedingRecipeProvider;
import com.portingdeadmods.moofluids.compat.jei.FluidCowJeiGuiHandler;
import com.portingdeadmods.moofluids.items.MFItems;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.handlers.IGlobalGuiHandler;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.advanced.ISimpleRecipeManagerPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IAdvancedRegistration;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class MFJeiPlugin
implements IModPlugin {
    public static final RecipeType<FluidCowBreedingRecipe> BREEDING_TYPE = RecipeType.create((String)"moofluids", (String)"fluid_cow_breeding", FluidCowBreedingRecipe.class);

    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"moofluids", (String)"jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new FluidCowBreedingCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(BREEDING_TYPE, FluidCowBreedingRecipeProvider.getBreedingRecipes(registration.getJeiHelpers()));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Items.WHEAT), new RecipeType[]{BREEDING_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)MFItems.ALCHEMY_GLASS.get()), new RecipeType[]{BREEDING_TYPE});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGlobalGuiHandler((IGlobalGuiHandler)new FluidCowJeiGuiHandler());
    }

    public void registerAdvanced(IAdvancedRegistration registration) {
        registration.addTypedRecipeManagerPlugin(BREEDING_TYPE, (ISimpleRecipeManagerPlugin)new FluidBreedingRecipeManagerPlugin());
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        AlchemyGlassJeiHandler.setJeiRuntime(jeiRuntime);
        FluidCowJeiGuiHandler.setJeiRuntime(jeiRuntime);
    }
}

