/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.moofluids.compat.jade;

import com.portingdeadmods.moofluids.FluidUtils;
import com.portingdeadmods.moofluids.entity.FluidCow;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public enum MFJadePlugin implements IEntityComponentProvider
{
    INSTANCE;


    public void appendTooltip(ITooltip iTooltip, EntityAccessor entityAccessor, IPluginConfig iPluginConfig) {
        Entity entity = entityAccessor.getEntity();
        if (entity instanceof FluidCow) {
            FluidCow fluidCow = (FluidCow)entity;
            boolean canBeMilk = fluidCow.canBeMilked();
            int color = FluidUtils.getFluidColor(fluidCow.getFluid());
            iTooltip.add((Component)Component.literal((String)"Fluid: ").append((Component)Component.translatable((String)fluidCow.getFluid().getFluidType().getDescriptionId()).withStyle(Style.EMPTY.withColor(color))));
            if (canBeMilk) {
                iTooltip.add((Component)Component.literal((String)"Can be Milked"));
            } else {
                iTooltip.add((Component)Component.literal((String)("Cooldown: " + fluidCow.getDelay() / 20 / 60 + "m " + fluidCow.getDelay() / 20 % 60 + "s")));
            }
        }
    }

    public ResourceLocation getUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"moofluids", (String)"fluid_cow");
    }
}

