/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.moofluids.compat.jade;

import com.portingdeadmods.moofluids.FluidUtils;
import com.portingdeadmods.moofluids.block.entity.FluidCowJarBlockEntity;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluids;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public enum FluidCowJarJadePlugin implements IBlockComponentProvider
{
    INSTANCE;


    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof FluidCowJarBlockEntity) {
            FluidCowJarBlockEntity fluidCowJar = (FluidCowJarBlockEntity)blockEntity;
            if (fluidCowJar.hasCow()) {
                if (fluidCowJar.getCowFluid() != Fluids.EMPTY) {
                    int color = FluidUtils.getFluidColor(fluidCowJar.getCowFluid());
                    tooltip.add((Component)Component.literal((String)"Fluid: ").append((Component)Component.translatable((String)fluidCowJar.getCowFluid().getFluidType().getDescriptionId()).withStyle(Style.EMPTY.withColor(color))));
                }
                int fluidAmount = fluidCowJar.getFluidTank().getFluidAmount();
                int capacity = fluidCowJar.getFluidTank().getCapacity();
                if (!fluidCowJar.getFluidTank().isEmpty() && fluidCowJar.getFluidTank().getFluid().getFluid() != fluidCowJar.getCowFluid()) {
                    tooltip.add((Component)Component.translatable((String)"moofluids.jade.fluid_mismatch").withStyle(Style.EMPTY.withColor(0xFF5555)));
                } else if (fluidCowJar.canBeMilked()) {
                    tooltip.add((Component)Component.literal((String)"Status: Ready to generate"));
                } else {
                    int cooldown = fluidCowJar.getMilkingCooldown();
                    tooltip.add((Component)Component.literal((String)("Cooldown: " + cooldown / 20 / 60 + "m " + cooldown / 20 % 60 + "s")));
                }
                if (fluidAmount >= capacity) {
                    tooltip.add((Component)Component.literal((String)"Tank: Full"));
                }
            } else {
                tooltip.add((Component)Component.literal((String)"Empty"));
                tooltip.add((Component)Component.literal((String)"Place cow and crush with anvil"));
            }
        }
    }

    public ResourceLocation getUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"moofluids", (String)"fluid_cow_jar");
    }
}

