/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.moofluids.block.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.portingdeadmods.moofluids.FluidUtils;
import com.portingdeadmods.moofluids.VertexUtil;
import com.portingdeadmods.moofluids.block.entity.FluidCowJarBlockEntity;
import com.portingdeadmods.moofluids.entity.FluidCow;
import com.portingdeadmods.moofluids.entity.MFEntities;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.CowModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.joml.Vector3f;

public class FluidCowJarRenderer
implements BlockEntityRenderer<FluidCowJarBlockEntity> {
    public static Map<ResourceLocation, Material> FLUID_TEXTURE_CACHE;
    private static final ResourceLocation COW_TEXTURE;
    private static FluidCow dummyCow;
    public static CowModel<FluidCow> COW_MODEL;

    public FluidCowJarRenderer(BlockEntityRendererProvider.Context context) {
        COW_MODEL = new CowModel(context.bakeLayer(ModelLayers.COW));
        FLUID_TEXTURE_CACHE = new HashMap<ResourceLocation, Material>();
    }

    public void render(FluidCowJarBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Level level = blockEntity.getLevel();
        if (level == null) {
            return;
        }
        if (blockEntity.hasCow()) {
            FluidCowJarRenderer.renderCowInJar(blockEntity.getFluidTank().getFluid(), blockEntity.getFluidTank().getCapacity(), blockEntity.getCowFluid(), partialTick, poseStack, bufferSource, packedLight, packedOverlay, level);
        }
    }

    public static void renderCowInJar(FluidStack fluidStack, int capacity, Fluid cowFluid, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, Level level) {
        if (dummyCow == null) {
            dummyCow = new FluidCow(MFEntities.FLUID_COW.get(), level);
        }
        if (cowFluid != Fluids.EMPTY) {
            dummyCow.setFluid(cowFluid.toString());
        }
        poseStack.pushPose();
        poseStack.translate(0.5, 0.1625, 0.5);
        float scale = 0.25f;
        poseStack.scale(scale, scale, scale);
        poseStack.mulPose(Axis.YP.rotationDegrees(((float)level.getGameTime() + partialTick) * 0.5f));
        poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        poseStack.translate(0.0, -1.25, 0.0);
        int color = FluidUtils.getFluidColor(cowFluid);
        FluidCowJarRenderer.COW_MODEL.young = false;
        COW_MODEL.prepareMobModel((Entity)dummyCow, 0.0f, 0.0f, partialTick);
        COW_MODEL.setupAnim((Entity)dummyCow, 0.0f, 0.0f, (float)level.getGameTime() + partialTick, 0.0f, 0.0f);
        VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)COW_TEXTURE));
        COW_MODEL.renderToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, color);
        poseStack.popPose();
        if (!fluidStack.isEmpty()) {
            IClientFluidTypeExtensions fluidTypeExtensions = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
            int tintColor = fluidTypeExtensions.getTintColor();
            FluidCowJarRenderer.renderFluid((float)fluidStack.getAmount() / (float)capacity, tintColor, 0, fluidTypeExtensions.getStillTexture(), poseStack, bufferSource, packedLight);
        }
    }

    public static void renderFluid(float percentageFill, int color, int luminosity, ResourceLocation texture, PoseStack poseStack, MultiBufferSource bufferIn, int light) {
        poseStack.pushPose();
        if (luminosity != 0) {
            light = light & 0xF00000 | luminosity << 4;
        }
        VertexConsumer builder = FLUID_TEXTURE_CACHE.computeIfAbsent(texture, k -> new Material(TextureAtlas.LOCATION_BLOCKS, k)).buffer(bufferIn, RenderType::entityTranslucentCull);
        Vector3f dimensions = new Vector3f(0.40625f, 0.5625f, 0.00625f);
        poseStack.translate(0.5, (double)dimensions.z(), 0.5);
        VertexUtil.addCube(builder, poseStack, dimensions.x(), percentageFill * dimensions.y(), light, color);
        poseStack.popPose();
    }

    static {
        COW_TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/entity/cow/cow.png");
    }
}

