/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.widgets.button;

import me.desht.modularrouters.client.gui.ISendToServer;
import me.desht.modularrouters.client.gui.widgets.button.IToggleButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;

public abstract class TexturedToggleButton
extends TexturedButton
implements IToggleButton {
    private boolean toggled;
    private Tooltip untoggledTooltip;
    private Tooltip toggledTooltip;

    public TexturedToggleButton(int x, int y, int width, int height, boolean toggled, ISendToServer dataSyncer) {
        super(x, y, width, height, button -> {
            ((TexturedToggleButton)button).toggle();
            if (dataSyncer != null) {
                dataSyncer.sendToServer();
            }
        });
        this.setToggled(toggled);
    }

    protected TexturedToggleButton setTooltips(Tooltip off, Tooltip on) {
        this.untoggledTooltip = off;
        this.toggledTooltip = on;
        this.setToggled(this.toggled);
        return this;
    }

    protected TexturedToggleButton setTooltips(Component c1, Component c2) {
        return this.setTooltips(Tooltip.create((Component)c1), Tooltip.create((Component)c2));
    }

    @Override
    public void toggle() {
        this.setToggled(!this.isToggled());
    }

    @Override
    public void setToggled(boolean toggled) {
        this.toggled = toggled;
        this.setTooltip(toggled ? this.toggledTooltip : this.untoggledTooltip);
    }

    @Override
    public boolean isToggled() {
        return this.toggled;
    }
}

