/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.tile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.components.FluidContents;
import mob_grinding_utils.components.MGUComponents;
import mob_grinding_utils.tile.TileEntityJumboTank;
import mob_grinding_utils.tile.TileEntitySinkTank;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class TileEntityTank
extends BlockEntity {
    public FluidTank tank = new FluidTank(32000);
    public int prevTankAmount;

    public TileEntityTank(BlockPos pos, BlockState state) {
        super(ModBlocks.TANK.getTileEntityType(), pos, state);
    }

    public TileEntityTank(BlockEntityType<TileEntitySinkTank> TANK_SINK_TILE, BlockPos pos, BlockState state) {
        super(TANK_SINK_TILE, pos, state);
    }

    public TileEntityTank(BlockEntityType<TileEntityJumboTank> JUMBO_TANK_TILE, FluidTank tankIn, BlockPos pos, BlockState state) {
        super(JUMBO_TANK_TILE, pos, state);
        this.tank = tankIn;
    }

    public static <T extends BlockEntity> void serverTick(Level world, BlockPos worldPosition, BlockState blockState, T t) {
        if (t instanceof TileEntityTank) {
            TileEntityTank tile = (TileEntityTank)t;
            if (tile.prevTankAmount != tile.tank.getFluidAmount()) {
                tile.updateBlock();
                tile.setChanged();
            }
            tile.prevTankAmount = tile.tank.getFluidAmount();
        }
    }

    public void updateBlock() {
        this.getLevel().sendBlockUpdated(this.worldPosition, this.getLevel().getBlockState(this.worldPosition), this.getLevel().getBlockState(this.worldPosition), 3);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet, @Nonnull HolderLookup.Provider registries) {
        super.onDataPacket(net, packet, registries);
        this.loadAdditional(packet.getTag(), registries);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag nbt = new CompoundTag();
        this.saveAdditional(nbt, (HolderLookup.Provider)this.level.registryAccess());
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @Nonnull
    public CompoundTag getUpdateTag(@Nonnull HolderLookup.Provider registries) {
        CompoundTag nbt = new CompoundTag();
        this.saveAdditional(nbt, registries);
        return nbt;
    }

    public void loadAdditional(@Nonnull CompoundTag nbt, @Nonnull HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.tank.readFromNBT(registries, nbt);
    }

    public void saveAdditional(@Nonnull CompoundTag nbt, @Nonnull HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        this.tank.writeToNBT(registries, nbt);
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public FluidTank getTank(@Nullable Direction direction) {
        return this.tank;
    }

    public int getScaledFluid(int scale) {
        return this.tank.getFluid() != null ? (int)((float)this.tank.getFluidAmount() / (float)this.tank.getCapacity() * (float)scale) : 0;
    }

    protected void applyImplicitComponents(@Nonnull BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        this.tank.setFluid(((FluidContents)componentInput.getOrDefault(MGUComponents.FLUID, (Object)FluidContents.EMPTY)).get());
    }

    protected void collectImplicitComponents(@Nonnull DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(MGUComponents.FLUID, (Object)FluidContents.of(this.tank.getFluid()));
    }
}

