/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.network;

import mob_grinding_utils.tile.BEGuiClickable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record BEGuiClick(BlockPos tilePos, int buttonID) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<BEGuiClick> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"mob_grinding_utils", (String)"gui_link"));
    public static final StreamCodec<FriendlyByteBuf, BEGuiClick> CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, BEGuiClick::tilePos, (StreamCodec)ByteBufCodecs.INT, BEGuiClick::buttonID, BEGuiClick::new);

    public static void handle(BEGuiClick message, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            BlockEntity blockEntity = ctx.player().level().getBlockEntity(message.tilePos);
            if (blockEntity instanceof BEGuiClickable) {
                BEGuiClickable clickable = (BEGuiClickable)blockEntity;
                clickable.buttonClicked(message.buttonID());
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

