/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModelXPSolidifier
extends Model {
    public ModelPart tank;
    public ModelPart top;
    public ModelPart rack;
    public ModelPart rack_top;
    public ModelPart rack_front;
    public ModelPart rack_left;
    public ModelPart rack_right;

    public ModelXPSolidifier(ModelPart root) {
        super(RenderType::entitySolid);
        this.tank = root.getChild("tank");
        this.top = root.getChild("top");
        this.rack = root.getChild("rack");
        this.rack_top = this.rack.getChild("rack_top");
        this.rack_front = this.rack.getChild("rack_front");
        this.rack_left = this.rack.getChild("rack_left");
        this.rack_right = this.rack.getChild("rack_right");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("top", CubeListBuilder.create().texOffs(0, 20).addBox(-8.0f, -11.0f, -8.0f, 16.0f, 3.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)24.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("tank", CubeListBuilder.create().texOffs(0, 40).addBox(-8.0f, -8.0f, -8.0f, 16.0f, 8.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)24.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rack = partdefinition.addOrReplaceChild("rack", CubeListBuilder.create().texOffs(25, 4).addBox(-2.0f, -4.0f, -1.0f, 4.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)14.0f, (float)6.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rack_top = rack.addOrReplaceChild("rack_top", CubeListBuilder.create().texOffs(17, 14).addBox(-6.0f, -6.0f, -2.0f, 12.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rack_front = rack.addOrReplaceChild("rack_front", CubeListBuilder.create().texOffs(19, 0).addBox(-6.0f, -5.0f, -13.0f, 12.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rack_left = rack.addOrReplaceChild("rack_left", CubeListBuilder.create().texOffs(6, 2).addBox(-6.0f, -5.0f, -12.0f, 1.0f, 1.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rack_right = rack.addOrReplaceChild("rack_right", CubeListBuilder.create().texOffs(36, 2).addBox(5.0f, -5.0f, -12.0f, 1.0f, 1.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, int color) {
        this.tank.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color);
    }

    public void renderExport(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, int color) {
        this.top.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color);
    }

    public void renderRack(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, int color) {
        this.rack.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color);
    }
}

