/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import mob_grinding_utils.tile.TileEntityFan;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TileEntityFanRenderer
implements BlockEntityRenderer<TileEntityFan> {
    public TileEntityFanRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(@Nonnull TileEntityFan tile, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (tile == null || !tile.hasLevel()) {
            return;
        }
        if (!tile.showRenderBox) {
            return;
        }
        VertexConsumer ivertexbuilder = buffer.getBuffer(RenderType.lines());
        matrixStack.pushPose();
        matrixStack.translate(-5.0E-4, -5.0E-4, -5.0E-4);
        matrixStack.scale(0.999f, 0.999f, 0.999f);
        LevelRenderer.renderLineBox((PoseStack)matrixStack, (VertexConsumer)ivertexbuilder, (AABB)tile.getAABBForRender(), (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        matrixStack.popPose();
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox(TileEntityFan blockEntity) {
        return blockEntity.getRenderBoundingBox();
    }
}

