/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.mecrh.util;

import dev.ftb.mods.mecrh.MECRHTags;
import dev.ftb.mods.mecrh.config.ServerConfig;
import dev.ftb.mods.mecrh.entity.EnderChicken;
import dev.ftb.mods.mecrh.event.EnderChickenEvent;
import dev.ftb.mods.mecrh.registry.ModAttachments;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.Nullable;

public class ChickenUtils {
    public static boolean hasChickenBoss(Entity entity) {
        return entity.hasData(ModAttachments.CHICKEN_ID);
    }

    public static boolean hasChickenBoss(Entity entity, EnderChicken chicken) {
        return ChickenUtils.hasChickenBoss(entity) && ((Integer)entity.getData(ModAttachments.CHICKEN_ID)).intValue() == chicken.getId();
    }

    @Nullable
    private static EnderChicken getChickenBoss(Entity entity) {
        EnderChicken chicken;
        if (!ChickenUtils.hasChickenBoss(entity)) {
            return null;
        }
        int id = (Integer)entity.getData(ModAttachments.CHICKEN_ID);
        Entity entity2 = entity.level().getEntity(id);
        return entity2 instanceof EnderChicken ? (chicken = (EnderChicken)entity2) : null;
    }

    public static void postChickenEvent(EnderChicken chicken, EnderChickenEvent.Phase phase) {
        NeoForge.EVENT_BUS.post((Event)new EnderChickenEvent((LivingEntity)chicken, phase));
    }

    public static void destroyBlocksInAABB(Entity ent, AABB aabb) {
        BlockPos.betweenClosedStream((AABB)aabb).forEach(pos -> ChickenUtils.destroyBlock(ent, pos));
    }

    public static void destroyBlock(Entity ent, BlockPos pos) {
        BlockState state = ent.level().getBlockState(pos);
        if (!state.isAir() && !state.is(BlockTags.FIRE) && !state.is(MECRHTags.Blocks.CHICKEN_UNBREAKABLE) && state.getBlock().canEntityDestroy(state, (BlockGetter)ent.level(), pos, ent) && state.getDestroySpeed((BlockGetter)ent.level(), pos) >= 0.0f) {
            ent.level().destroyBlock(pos, ((Boolean)ServerConfig.DROP_BROKEN_BLOCKS.get()).booleanValue());
        }
    }

    public static boolean isEnderChickenFriend(Entity e) {
        return e != null && (ChickenUtils.hasChickenBoss(e) || e.getType().is(MECRHTags.Entities.CHICKEN_FRIENDS));
    }
}

