/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.mecrh.entity.ai;

import dev.ftb.mods.mecrh.entity.EnderChicken;
import dev.ftb.mods.mecrh.entity.ai.ChickenGoal;
import java.util.Objects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class ChickenLaserGoal
extends ChickenGoal {
    public static final int WARMUP_TIME = 59;
    public static final int LASER_DURATION = 160;
    private Vec3 beamPathVector;
    private Vec3 targetStart;

    public ChickenLaserGoal(EnderChicken chicken) {
        super(chicken);
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    @Override
    public boolean canUse() {
        return super.canUse() && !this.chicken.isFiringLaser() && this.chicken.getTarget() != null && this.chicken.getTarget().isAlive() && this.chicken.isLaserReady(this.chicken.getTarget().getY() > this.chicken.partBody.getY() + (double)this.chicken.partBody.getBbHeight());
    }

    public boolean canContinueToUse() {
        return this.chicken.isFiringLaser() && this.chicken.isAlive() && this.chicken.getFiringProgress() < 160;
    }

    public void start() {
        this.chicken.useAbility();
        this.chicken.setFiringLaser(true);
        LivingEntity target = this.chicken.getTarget();
        if (target != null) {
            this.targetStart = target.position().add(0.0, (double)(target.getBbHeight() / 2.0f), 0.0);
        }
    }

    public void stop() {
        this.chicken.endAbility();
        this.chicken.setFiringLaser(false);
        this.targetStart = null;
        this.beamPathVector = null;
    }

    public void tick() {
        LivingEntity target = this.chicken.getTarget();
        if (this.chicken.getFiringProgress() == 1) {
            if (target != null) {
                this.targetStart = target.position().add(0.0, (double)(target.getBbHeight() / 2.0f), 0.0);
            }
        } else if (this.chicken.getFiringProgress() < 59) {
            if (this.targetStart != null) {
                this.chicken.getLookControl().setLookAt(this.targetStart);
            }
        } else if (this.chicken.getFiringProgress() == 59) {
            double maxRange = 5.0;
            Vec3 targetEnd = null;
            if (target != null) {
                targetEnd = target.position().add(0.0, (double)(target.getBbHeight() / 2.0f), 0.0);
                double dist = this.chicken.distanceTo((Entity)target);
                if (dist < maxRange) {
                    maxRange = dist;
                }
            }
            boolean startNull = this.targetStart == null;
            RandomSource rnd = this.chicken.getRandom();
            if (startNull) {
                this.targetStart = Objects.requireNonNullElseGet(targetEnd, () -> ((EnderChicken)this.chicken).position()).add(this.randomBeamOffset(rnd));
            }
            if (targetEnd == null) {
                targetEnd = !startNull ? this.targetStart.add(this.randomBeamOffset(rnd)) : this.chicken.position().add(this.randomBeamOffset(rnd));
            }
            if (targetEnd.equals((Object)this.targetStart)) {
                targetEnd = targetEnd.add(this.randomBeamOffset(rnd));
            }
            Vec3 normVec = targetEnd.subtract(this.targetStart).normalize();
            double regress = rnd.nextDouble() * maxRange;
            this.targetStart = this.targetStart.subtract(normVec.x * regress, normVec.y * regress, normVec.z * regress);
            double progress = rnd.nextDouble() * maxRange;
            targetEnd = targetEnd.add(normVec.x * progress, normVec.y * progress, normVec.z * progress);
            this.beamPathVector = targetEnd.subtract(this.targetStart);
            this.targetStart = this.targetStart.subtract(this.chicken.position());
        }
        if (this.chicken.getFiringProgress() > 59 && this.chicken.getFiringProgress() < 160) {
            if (target != null) {
                double chickenHeadTop = this.chicken.partHead.getY() + (double)this.chicken.partHead.getBbHeight();
                if (target.getY() > chickenHeadTop) {
                    this.chicken.getLookControl().setLookAt(target.getX(), target.getY() + (double)target.getBbHeight() / 2.0, target.getZ());
                    return;
                }
            }
            Vec3 beamTarget = this.chicken.position().add(this.targetStart).add(this.beamPathVector.scale(this.beamProgress()));
            this.chicken.getLookControl().setLookAt(beamTarget.x, beamTarget.y, beamTarget.z, (float)this.chicken.getHeadRotSpeed(), 45.0f);
        }
    }

    private Vec3 randomBeamOffset(RandomSource rnd) {
        return new Vec3(rnd.nextGaussian() * 20.0, rnd.nextGaussian() * 8.0, rnd.nextGaussian() * 20.0);
    }

    private double beamProgress() {
        double start = 60.0;
        return ((double)this.chicken.getFiringProgress() - start) / (160.0 - start);
    }
}

