/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.util.module;

import dev.su5ed.mffs.api.fortron.FortronStorage;
import dev.su5ed.mffs.api.module.ModuleType;
import dev.su5ed.mffs.api.security.BiometricIdentifier;
import dev.su5ed.mffs.api.security.FieldPermission;
import dev.su5ed.mffs.api.security.InterdictionMatrix;
import dev.su5ed.mffs.setup.ModCapabilities;
import dev.su5ed.mffs.util.ModUtil;
import dev.su5ed.mffs.util.module.BaseInterdictionModule;
import java.util.Collection;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import one.util.streamex.StreamEx;

public class ConfiscationModule
extends BaseInterdictionModule {
    public ConfiscationModule(ModuleType<?> type, ItemStack stack) {
        super(type, stack);
    }

    @Override
    public boolean onDefend(InterdictionMatrix interdictionMatrix, LivingEntity target) {
        if (target instanceof Player) {
            Player player = (Player)target;
            BiometricIdentifier identifier = interdictionMatrix.getBiometricIdentifier();
            if (identifier != null && identifier.isAccessGranted(player, FieldPermission.BYPASS_CONFISCATION)) {
                return false;
            }
        }
        BiometricIdentifier identifier = interdictionMatrix.getBiometricIdentifier();
        if (target instanceof Player) {
            Player player = (Player)target;
            if (identifier == null || !identifier.isAccessGranted(player, FieldPermission.BYPASS_DEFENSE)) {
                Inventory inventory = player.getInventory();
                Collection<ItemStack> filteredItems = interdictionMatrix.getFilteredItems();
                int confiscationCount = 0;
                for (int i = 0; i < inventory.getContainerSize(); ++i) {
                    ItemStack checkStack = inventory.getItem(i);
                    if (checkStack.isEmpty()) continue;
                    boolean stacksMatch = StreamEx.of(filteredItems).anyMatch(stack -> ItemStack.isSameItem((ItemStack)stack, (ItemStack)checkStack));
                    InterdictionMatrix.ConfiscationMode mode = interdictionMatrix.getConfiscationMode();
                    if ((mode != InterdictionMatrix.ConfiscationMode.BLACKLIST || !stacksMatch) && (mode != InterdictionMatrix.ConfiscationMode.WHITELIST || stacksMatch)) continue;
                    interdictionMatrix.mergeIntoInventory(inventory.getItem(i));
                    inventory.setItem(i, ItemStack.EMPTY);
                    ++confiscationCount;
                }
                if (confiscationCount > 0) {
                    player.displayClientMessage((Component)ModUtil.translate("info", "interdiction_matrix.confiscation_" + (confiscationCount == 1 ? "singular" : "plural"), interdictionMatrix.getTitle(), confiscationCount), false);
                    BlockEntity be = interdictionMatrix.be();
                    FortronStorage fortron = (FortronStorage)be.getLevel().getCapability(ModCapabilities.FORTRON, be.getBlockPos(), be.getBlockState(), be, null);
                    if (fortron != null) {
                        fortron.extractFortron(confiscationCount, false);
                    }
                }
            }
        }
        return false;
    }
}

