/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.util;

import dev.su5ed.mffs.setup.ModDataComponentTypes;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class ItemEnergyStorage
implements IEnergyStorage {
    private final ItemStack stack;
    private final int capacity;
    private final int maxTransfer;

    public ItemEnergyStorage(ItemStack stack, int capacity, int maxTransfer) {
        this.stack = stack;
        this.capacity = capacity;
        this.maxTransfer = maxTransfer;
    }

    private void setEnergyStored(int energy) {
        this.stack.set(ModDataComponentTypes.ENERGY, (Object)energy);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int energyStored = this.getEnergyStored();
        int energyReceived = Math.min(this.getMaxEnergyStored() - energyStored, Math.min(this.maxTransfer, maxReceive));
        if (!simulate) {
            this.setEnergyStored(energyStored + energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int energyStored = this.getEnergyStored();
        int energyExtracted = Math.min(energyStored, Math.min(this.maxTransfer, maxExtract));
        if (!simulate) {
            this.setEnergyStored(energyStored - energyExtracted);
        }
        return energyExtracted;
    }

    public int getEnergyStored() {
        return (Integer)this.stack.getOrDefault(ModDataComponentTypes.ENERGY, (Object)0);
    }

    public int getMaxEnergyStored() {
        return this.capacity;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }
}

