/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.su5ed.mffs.MFFSConfig;
import dev.su5ed.mffs.api.Projector;
import dev.su5ed.mffs.api.module.ProjectorMode;
import dev.su5ed.mffs.item.BaseItem;
import dev.su5ed.mffs.setup.ModDataComponentTypes;
import dev.su5ed.mffs.setup.ModObjects;
import dev.su5ed.mffs.util.ModUtil;
import dev.su5ed.mffs.util.loot.FieldShapeTrigger;
import dev.su5ed.mffs.util.projector.CustomStructureSavedData;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import org.apache.commons.lang3.RandomStringUtils;
import org.jetbrains.annotations.Nullable;

public class CustomProjectorModeItem
extends BaseItem {
    private CustomStructureSavedData structureManager;

    public CustomProjectorModeItem() {
        super(new BaseItem.ExtendedItemProperties(new Item.Properties().stacksTo(1)));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ItemStack stack = player.getItemInHand(usedHand);
                StructureCoords coords = (StructureCoords)stack.get(ModDataComponentTypes.STRUCTURE_COORDS);
                if (player.isShiftKeyDown()) {
                    CustomStructureSavedData data = this.getOrCreateData(serverLevel);
                    if (coords != null && coords.canBuild()) {
                        int distance;
                        BlockPos secondary;
                        BlockPos primary = coords.primary();
                        if (primary.closerThan((Vec3i)(secondary = coords.secondary()), (double)(distance = ((Integer)MFFSConfig.COMMON.maxCustomModeScale.get()).intValue()))) {
                            stack.remove(ModDataComponentTypes.STRUCTURE_COORDS);
                            String id = this.getOrCreateId(stack);
                            data.join(id, level, serverPlayer, primary, secondary, this.getMode(stack) == Mode.ADDITIVE);
                            player.displayClientMessage((Component)ModUtil.translate("item", "custom_mode.data_saved", new Object[0]), true);
                            ((FieldShapeTrigger)((Object)ModObjects.FIELD_SHAPE_TRIGGER.get())).trigger(serverPlayer);
                        } else {
                            player.displayClientMessage((Component)ModUtil.translate("item", "custom_mode.too_far", distance), true);
                        }
                        return InteractionResultHolder.success((Object)stack);
                    }
                    if (stack.has(ModDataComponentTypes.PATTERN_ID)) {
                        String id = (String)stack.get(ModDataComponentTypes.PATTERN_ID);
                        data.clear(level, serverPlayer, id);
                        stack.remove(ModDataComponentTypes.PATTERN_ID);
                        player.displayClientMessage((Component)ModUtil.translate("item", "custom_mode.clear", new Object[0]), true);
                        return InteractionResultHolder.success((Object)stack);
                    }
                } else if (coords != null && coords.selectSecondary()) {
                    HitResult result = player.pick(player.blockInteractionRange(), 0.0f, true);
                    if (result instanceof BlockHitResult) {
                        BlockHitResult blockHitResult = (BlockHitResult)result;
                        stack.set(ModDataComponentTypes.STRUCTURE_COORDS, (Object)new StructureCoords(coords.primary(), blockHitResult.getBlockPos()));
                        this.selectBlock(player, "secondary_point", ChatFormatting.GOLD);
                        return InteractionResultHolder.success((Object)stack);
                    }
                } else {
                    Mode mode = this.setMode(stack, this.getMode(stack).next());
                    player.displayClientMessage((Component)ModUtil.translate("item", "custom_mode.changed_mode", mode.getName().withStyle(ChatFormatting.GREEN)), true);
                    return InteractionResultHolder.consume((Object)stack);
                }
            }
        }
        return super.use(level, player, usedHand);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Level level = context.getLevel();
        if (!level.isClientSide) {
            BlockPos pos = context.getClickedPos();
            Player player = context.getPlayer();
            StructureCoords coords = (StructureCoords)stack.get(ModDataComponentTypes.STRUCTURE_COORDS);
            if (coords == null || coords.selectPrimary()) {
                stack.set(ModDataComponentTypes.STRUCTURE_COORDS, (Object)new StructureCoords(pos, null));
                this.selectBlock(player, "primary_point", ChatFormatting.GREEN);
            } else if (coords != null) {
                stack.set(ModDataComponentTypes.STRUCTURE_COORDS, (Object)new StructureCoords(coords.primary(), pos));
                this.selectBlock(player, "secondary_point", ChatFormatting.GOLD);
            }
        }
        return InteractionResult.SUCCESS;
    }

    private void selectBlock(Player player, String key, ChatFormatting color) {
        MutableComponent component = ModUtil.translate("item", "custom_mode.set_" + key, new Object[0]).withStyle(color);
        player.displayClientMessage((Component)component, true);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        StructureCoords coords;
        Mode mode = this.getMode(stack);
        tooltipComponents.add((Component)ModUtil.translate("item", "custom_mode.mode", mode.getName().withStyle(ChatFormatting.GRAY)).withStyle(ChatFormatting.DARK_GRAY));
        String id = (String)stack.get(ModDataComponentTypes.PATTERN_ID);
        if (id != null) {
            tooltipComponents.add((Component)ModUtil.translate("item", "custom_mode.pattern_id", Component.literal((String)id).withStyle(ChatFormatting.GRAY)).withStyle(ChatFormatting.DARK_GRAY));
        }
        if ((coords = (StructureCoords)stack.get(ModDataComponentTypes.STRUCTURE_COORDS)) != null && coords.primary() != null) {
            tooltipComponents.add((Component)ModUtil.translate("item", "custom_mode.set_primary_point", Component.literal((String)coords.primary().toShortString()).withStyle(ChatFormatting.GRAY)).withStyle(ChatFormatting.DARK_GRAY));
            if (coords.secondary() != null) {
                tooltipComponents.add((Component)ModUtil.translate("item", "custom_mode.secondary_point", Component.literal((String)coords.secondary().toShortString()).withStyle(ChatFormatting.GRAY)).withStyle(ChatFormatting.DARK_GRAY));
                tooltipComponents.add((Component)ModUtil.translate("item", "custom_mode.set_secondary_point", new Object[0]).withStyle(ChatFormatting.GOLD));
            } else {
                tooltipComponents.add((Component)ModUtil.translate("item", "custom_mode.set_primary_point", new Object[0]).withStyle(ChatFormatting.LIGHT_PURPLE));
            }
        }
        super.appendHoverText(stack, context, tooltipComponents, isAdvanced);
    }

    public Mode getMode(ItemStack stack) {
        return (Mode)((Object)stack.getOrDefault(ModDataComponentTypes.STRUCTURE_MODE, (Object)Mode.ADDITIVE));
    }

    public Mode setMode(ItemStack stack, Mode mode) {
        stack.set(ModDataComponentTypes.STRUCTURE_MODE, (Object)mode);
        return mode;
    }

    public String getOrCreateId(ItemStack stack) {
        if (!stack.has(ModDataComponentTypes.PATTERN_ID)) {
            String id = RandomStringUtils.randomAlphanumeric((int)8).toUpperCase(Locale.ROOT);
            stack.set(ModDataComponentTypes.PATTERN_ID, (Object)id);
            return id;
        }
        return (String)stack.get(ModDataComponentTypes.PATTERN_ID);
    }

    public CustomStructureSavedData getOrCreateData(ServerLevel level) {
        if (this.structureManager == null) {
            this.structureManager = (CustomStructureSavedData)level.getServer().overworld().getDataStorage().computeIfAbsent(new SavedData.Factory(CustomStructureSavedData::new, (tag, provider) -> {
                CustomStructureSavedData data = new CustomStructureSavedData();
                data.load((CompoundTag)tag);
                return data;
            }), "mffs_custom_structures");
        }
        return this.structureManager;
    }

    public Map<Vec3, BlockState> getFieldBlocks(Projector projector, ItemStack stack) {
        String id;
        ServerLevel serverLevel;
        CustomStructureSavedData data;
        CustomStructureSavedData.Structure structure;
        Level level = projector.be().getLevel();
        if (level instanceof ServerLevel && (structure = (data = this.getOrCreateData(serverLevel = (ServerLevel)level)).get(id = (String)stack.get(ModDataComponentTypes.PATTERN_ID))) != null) {
            return structure.getRealBlocks();
        }
        return Map.of();
    }

    public record StructureCoords(@Nullable BlockPos primary, @Nullable BlockPos secondary) {
        public static final Codec<StructureCoords> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.CODEC.optionalFieldOf("primary", null).forGetter(StructureCoords::primary), (App)BlockPos.CODEC.optionalFieldOf("secondary", null).forGetter(StructureCoords::secondary)).apply((Applicative)instance, StructureCoords::new));
        public static final StreamCodec<FriendlyByteBuf, StructureCoords> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC.apply(ModUtil.nullable()), StructureCoords::primary, (StreamCodec)BlockPos.STREAM_CODEC.apply(ModUtil.nullable()), StructureCoords::secondary, StructureCoords::new);

        public boolean canBuild() {
            return this.primary != null && this.secondary != null;
        }

        public boolean selectPrimary() {
            return this.primary == null || this.secondary != null;
        }

        public boolean selectSecondary() {
            return this.primary != null && this.secondary == null;
        }
    }

    public static enum Mode implements StringRepresentable
    {
        ADDITIVE,
        SUBTRACTIVE;

        private static final Mode[] VALUES;
        public static final Codec<Mode> CODEC;
        public static final StreamCodec<FriendlyByteBuf, Mode> STREAM_CODEC;

        public Mode next() {
            return VALUES[(this.ordinal() + 1) % VALUES.length];
        }

        public MutableComponent getName() {
            return ModUtil.translate("item", "custom_mode.mode." + this.name().toLowerCase(Locale.ROOT), new Object[0]);
        }

        public String getSerializedName() {
            return this.name();
        }

        static {
            VALUES = Mode.values();
            CODEC = StringRepresentable.fromEnum(Mode::values);
            STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(Mode.class);
        }
    }

    public class CustomProjectorModeCapability
    implements ProjectorMode {
        private final ItemStack stack;

        public CustomProjectorModeCapability(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        public Set<Vec3> getExteriorPoints(Projector projector) {
            return CustomProjectorModeItem.this.getFieldBlocks(projector, this.stack).keySet();
        }

        @Override
        public Set<Vec3> getInteriorPoints(Projector projector) {
            return this.getExteriorPoints(projector);
        }

        @Override
        public boolean isInField(Projector projector, Vec3 position) {
            return false;
        }
    }
}

