/*
 * Decompiled with CFR 0.152.
 */
package tfar.metalbarrels.item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import tfar.metalbarrels.util.UpgradeInfo;

public abstract class BarrelUpgradeItem
extends Item {
    protected final UpgradeInfo upgradeInfo;

    public BarrelUpgradeItem(Item.Properties properties, UpgradeInfo info) {
        super(properties);
        this.upgradeInfo = info;
    }

    public InteractionResult useOn(UseOnContext context) {
        Block newBlock;
        BlockState newState;
        Player player = context.getPlayer();
        BlockPos pos = context.getClickedPos();
        Level world = context.getLevel();
        ItemStack heldStack = context.getItemInHand();
        BlockState state = world.getBlockState(pos);
        if (player == null || !this.upgradeInfo.canUpgrade(world.getBlockState(pos))) {
            return InteractionResult.FAIL;
        }
        if (world.isClientSide || player.getPose() != Pose.CROUCHING) {
            return InteractionResult.PASS;
        }
        if (state.getBlock() instanceof BarrelBlock && ((Boolean)state.getValue((Property)BlockStateProperties.OPEN)).booleanValue()) {
            player.displayClientMessage((Component)Component.translatable((String)"metalbarrels.in_use").withStyle(Style.EMPTY.applyFormat(ChatFormatting.RED)), true);
            return InteractionResult.PASS;
        }
        BlockEntity oldBarrel = world.getBlockEntity(pos);
        ArrayList<ItemStack> oldBarrelContents = new ArrayList<ItemStack>();
        Direction facing = Direction.NORTH;
        if (state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        } else if (state.hasProperty((Property)BlockStateProperties.FACING)) {
            facing = (Direction)state.getValue((Property)BlockStateProperties.FACING);
        }
        if (oldBarrel != null) {
            this.copyOldItems(world, pos, state, oldBarrel, oldBarrelContents);
            oldBarrel.setRemoved();
        }
        if ((newState = (newBlock = this.upgradeInfo.end_block()).defaultBlockState()).hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            newState = (BlockState)newState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facing);
        } else if (newState.hasProperty((Property)BlockStateProperties.FACING)) {
            newState = (BlockState)newState.setValue((Property)BlockStateProperties.FACING, (Comparable)facing);
        }
        world.setBlock(pos, newState, 3);
        BlockEntity newBarrel = world.getBlockEntity(pos);
        if (newBarrel != null) {
            this.setNewItems(world, pos, newState, newBarrel, oldBarrelContents);
        }
        if (!player.getAbilities().instabuild) {
            heldStack.shrink(1);
        }
        player.displayClientMessage((Component)Component.translatable((String)"metalbarrels.upgrade_successful").withStyle(Style.EMPTY.applyFormat(ChatFormatting.GREEN)), true);
        return InteractionResult.SUCCESS;
    }

    protected abstract void copyOldItems(Level var1, BlockPos var2, BlockState var3, BlockEntity var4, List<ItemStack> var5);

    protected abstract void setNewItems(Level var1, BlockPos var2, BlockState var3, BlockEntity var4, List<ItemStack> var5);

    public UpgradeInfo getUpgradeInfo() {
        return this.upgradeInfo;
    }
}

