/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.mekagenjei.client.jei;

import com.devdyna.mekagenjei.client.jei.categories.BioFuelCategory;
import com.devdyna.mekagenjei.client.jei.categories.FusionFuelCategory;
import com.devdyna.mekagenjei.client.jei.categories.GasBurningCategory;
import com.devdyna.mekagenjei.client.jei.categories.PumpExtractionCategory;
import com.devdyna.mekagenjei.client.jei.categories.RadioactiveBarrelCategory;
import com.devdyna.mekagenjei.client.jei.categories.TurbineCategory;
import com.devdyna.mekagenjei.utils.x;
import com.devdyna.mekagenjei.zStatic;
import java.util.List;
import mekanism.common.registries.MekanismBlocks;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.registries.GeneratorsItems;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class MainPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return x.rl("jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration event) {
        IGuiHelper guiHelper = event.getJeiHelpers().getGuiHelper();
        event.addRecipeCategories(new IRecipeCategory[]{new BioFuelCategory(guiHelper), new GasBurningCategory(guiHelper), new TurbineCategory(guiHelper), new RadioactiveBarrelCategory(guiHelper), new FusionFuelCategory(guiHelper), new PumpExtractionCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration event) {
        event.addRecipes(BioFuelCategory.TYPE, List.of(zStatic.BIOFUEL.values()));
        event.addRecipes(GasBurningCategory.TYPE, List.of(zStatic.GASBURNING.values()));
        event.addRecipes(TurbineCategory.TYPE, List.of(zStatic.TURBINE.values()));
        event.addRecipes(RadioactiveBarrelCategory.TYPE, List.of(zStatic.WASTE.values()));
        event.addRecipes(PumpExtractionCategory.TYPE, List.of(zStatic.PUMP.values()));
        event.addRecipes(FusionFuelCategory.TYPE, List.of(zStatic.FUSION_FUELS.values()));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration event) {
        event.addRecipeCatalyst((ItemLike)GeneratorsBlocks.GAS_BURNING_GENERATOR, new RecipeType[]{GasBurningCategory.TYPE});
        event.addRecipeCatalyst((ItemLike)GeneratorsBlocks.BIO_GENERATOR, new RecipeType[]{BioFuelCategory.TYPE});
        event.addRecipeCatalysts(TurbineCategory.TYPE, new ItemLike[]{GeneratorsBlocks.TURBINE_CASING, GeneratorsBlocks.TURBINE_VALVE, GeneratorsBlocks.TURBINE_VENT, GeneratorsItems.TURBINE_BLADE, GeneratorsBlocks.TURBINE_ROTOR, GeneratorsBlocks.ELECTROMAGNETIC_COIL, GeneratorsBlocks.ROTATIONAL_COMPLEX, GeneratorsBlocks.SATURATING_CONDENSER});
        event.addRecipeCatalyst((ItemLike)MekanismBlocks.RADIOACTIVE_WASTE_BARREL, new RecipeType[]{RadioactiveBarrelCategory.TYPE});
        event.addRecipeCatalyst((ItemLike)MekanismBlocks.ELECTRIC_PUMP, new RecipeType[]{PumpExtractionCategory.TYPE});
        event.addRecipeCatalysts(FusionFuelCategory.TYPE, new ItemLike[]{GeneratorsItems.HOHLRAUM, GeneratorsBlocks.FUSION_REACTOR_CONTROLLER, GeneratorsBlocks.FUSION_REACTOR_FRAME, GeneratorsBlocks.FUSION_REACTOR_LOGIC_ADAPTER, GeneratorsBlocks.FUSION_REACTOR_PORT, GeneratorsBlocks.LASER_FOCUS_MATRIX});
    }
}

