/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects.networked.attack;

import com.sammy.malum.registry.common.MalumParticles;
import com.sammy.malum.visual_effects.WeaponParticleEffects;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import com.sammy.malum.visual_effects.networked.MalumNetworkedWeaponParticleEffectType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.network.WeaponParticleEffectType;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectPositionData;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.GenericParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.world.behaviors.LodestoneParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.behaviors.PointyDirectionalParticleBehavior;

public class AscensionUppercutParticleEffect
extends MalumNetworkedWeaponParticleEffectType<WeaponParticleEffectType.WeaponParticleEffectData> {
    public AscensionUppercutParticleEffect(String id) {
        super(id);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void act(Level level, RandomSource random, NetworkedParticleEffectPositionData positionData, MalumNetworkedParticleEffectColorData colorData, WeaponParticleEffectType.WeaponParticleEffectData extraData) {
        Vec3 direction = extraData.getDirection();
        float yRot = (float)(Mth.atan2((double)direction.x, (double)direction.z) * 57.2957763671875);
        float yaw = (float)Math.toRadians(yRot);
        Vec3 left = new Vec3(-Math.cos(yaw), 0.0, Math.sin(yaw));
        Vec3 up = left.cross(direction);
        for (int i = 0; i < 6; ++i) {
            float upwardsOffset = (float)i * 0.4f;
            float slashOffset = 2.0f - (float)i * 0.6f;
            for (int j = 0; j < 2; ++j) {
                float spinOffset = extraData.getSlashRotation() + RandomHelper.randomBetween((RandomSource)random, (float)-0.25f, (float)0.25f) + (extraData.isMirrored() ? 3.14f : 0.0f);
                Vec3 slashPosition = positionData.getAsVector().add(direction.scale((double)slashOffset)).add(up.scale((double)upwardsOffset));
                ParticleEffectSpawner slash = WeaponParticleEffects.spawnSlashParticle(level, slashPosition, MalumParticles.SLASH, colorData);
                slash.getBuilder().setSpinData((SpinParticleDataWrapper)SpinParticleData.create((float)0.0f).setSpinOffset(spinOffset).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)RandomHelper.randomBetween((RandomSource)random, (float)2.5f, (float)3.0f)).build()).setMotion(direction.scale((double)RandomHelper.randomBetween((RandomSource)random, (float)0.2f, (float)0.4f)).add(0.0, (double)0.8f, 0.0)).setLifetime(3 + i).setLifeDelay(i / 2).setBehavior((LodestoneParticleBehavior)PointyDirectionalParticleBehavior.pointyDirectional((Vec3)direction));
                slash.spawnParticles();
            }
        }
    }
}

