/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects;

import com.sammy.malum.client.SpiritBasedParticleBuilder;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.registry.common.MalumParticles;
import com.sammy.malum.visual_effects.SparkParticleEffects;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import com.sammy.malum.visual_effects.networked.geas.LifeweaverHealingBeamParticleEffect;
import java.awt.Color;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.handlers.LodestoneRenderHandler;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.VecHelper;
import team.lodestar.lodestone.registry.common.particle.LodestoneParticleTypes;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.network.WeaponParticleEffectType;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectPositionData;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.GenericParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;
import team.lodestar.lodestone.systems.particle.world.behaviors.DirectionalParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.behaviors.LodestoneParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.behaviors.SparkParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.options.WorldParticleOptions;
import team.lodestar.lodestone.systems.particle.world.type.LodestoneWorldParticleType;
import team.lodestar.lodestone.systems.rendering.buffer.LodestoneRenderLayer;

public class GeasParticleEffects {
    public static void lifeWeaverHealingBeam(Level level, RandomSource random, NetworkedParticleEffectPositionData positionData, MalumNetworkedParticleEffectColorData colorData, LifeweaverHealingBeamParticleEffect.LifeweaverHealingBeamEffectData extraData) {
        Entity target = level.getEntity(extraData.targetId());
        Entity source = level.getEntity(extraData.sourceId());
        if (target != null && source != null) {
            Vec3 pos = positionData.getAsVector();
            Vec3 targetPos = target.position().add(0.0, (double)(target.getBbHeight() / 2.0f), 0.0);
            Vec3 direction = targetPos.subtract(pos).normalize();
            float yRot = (float)(Mth.atan2((double)direction.x, (double)direction.z) * 57.2957763671875);
            float yaw = (float)Math.toRadians(yRot);
            Vec3 left = new Vec3(-Math.cos(yaw), 0.0, Math.sin(yaw));
            Vec3 up = left.cross(direction);
            Consumer<LodestoneWorldParticle> behavior = p -> {
                float partialTick = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
                SparkParticleBehavior spark = (SparkParticleBehavior)p.behavior;
                Vec3 distance = target.getPosition(partialTick).add(0.0, (double)(target.getBbHeight() / 2.0f), 0.0).subtract(p.getParticlePosition());
                spark.setForcedDirection(distance.normalize());
                float length = (float)Math.clamp(distance.length(), 2.0, 4.0);
                p.lengthData.overrideValueMultiplier(length / 6.0f);
                p.scaleData.overrideValueMultiplier(length / 4.0f);
            };
            for (int i = 0; i < 4; ++i) {
                SpiritArcanaType cyclingSpiritType = colorData.getSpirit();
                float spread = RandomHelper.randomBetween((RandomSource)random, (float)0.6f, (float)0.8f);
                float speed = RandomHelper.randomBetween((RandomSource)random, (float)0.6f, (float)0.8f);
                float angle = (float)i / 4.0f * (float)Math.PI * 2.0f;
                Vec3 particleDirection = direction.add(left.scale(Math.sin(angle) * (double)spread)).add(up.scale(Math.cos(angle) * (double)spread)).normalize().scale((double)speed);
                Vec3 particlePosition = pos.add(particleDirection.scale((double)0.4f));
                int lifeDelay = i * 2;
                SpiritBasedParticleBuilder.createSpirit(LodestoneParticleTypes.EXTRUDING_SPARK_PARTICLE).setSpirit(cyclingSpiritType).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.0f, (float)0.7f, (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN_OUT).build()).setLengthData((GenericParticleDataWrapper)GenericParticleData.create((float)0.8f, (float)2.6f, (float)0.4f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN_OUT).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)0.2f, (float)0.4f, (float)0.2f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN_OUT).build()).setBehavior((LodestoneParticleBehavior)SparkParticleBehavior.sparkBehavior().setForcedDirection(direction).setLengthCenter(1.0f)).setRandomOffset(0.1f).setLifetime(15).setLifeDelay(lifeDelay).enableNoClip().addRenderActor((Consumer)behavior).spawn(level, particlePosition.x, particlePosition.y, particlePosition.z);
                SpiritBasedParticleBuilder.createSpirit(MalumParticles.GIANT_GLOWING_STAR).setSpirit(cyclingSpiritType).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.2f, (float)0.3f, (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN_OUT).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)0.3f, (float)0.6f, (float)0.2f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN_OUT).build()).setLifetime(15).setLifeDelay(lifeDelay).enableNoClip().spawn(level, particlePosition.x, particlePosition.y, particlePosition.z);
                SpiritBasedParticleBuilder.createSpirit(MalumParticles.STAR).setSpirit(cyclingSpiritType).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.15f, (float)0.5f, (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN_OUT).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)0.05f, (float)0.2f, (float)0.1f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN_OUT).build()).setLifetime(15).setLifeDelay(lifeDelay).enableNoClip().spawn(level, particlePosition.x, particlePosition.y, particlePosition.z);
            }
            long gameTime = level.getGameTime();
            float time = 16.0f;
            for (int i = 0; i < 6; ++i) {
                Vec3 offsetTargetPosition = VecHelper.rotatingRadialOffset((Vec3)targetPos, (float)1.1f, (float)i, (float)6.0f, (float)gameTime, (float)time);
                double timeOffset = Math.cos((float)(gameTime + (long)(i * 480)) % time / time) * 0.25 - 0.25;
                offsetTargetPosition = offsetTargetPosition.add(0.0, timeOffset, 0.0);
                for (int j = 0; j < 2; ++j) {
                    ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, offsetTargetPosition, colorData.getColor());
                    float velocity = -RandomHelper.randomBetween((RandomSource)random, (float)0.05f, (float)0.1f);
                    Vec3 motion = offsetTargetPosition.subtract(targetPos).normalize().scale((double)velocity);
                    lightSpecs.getBuilder().multiplyLifetime(0.8f).setMotion(motion).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.2f, (float)0.8f, (float)0.0f).build()).modifyScaleData(d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)1.0f, (float)2.0f)));
                    lightSpecs.getBloomBuilder().multiplyLifetime(0.6f).setMotion(motion).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.05f, (float)0.35f, (float)0.0f).build()).modifyScaleData(d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)0.5f, (float)1.0f)));
                    lightSpecs.spawnParticles();
                }
            }
        }
    }

    public static void warlockBlast(Level level, RandomSource random, NetworkedParticleEffectPositionData positionData, MalumNetworkedParticleEffectColorData colorData, WeaponParticleEffectType.WeaponParticleEffectData extraData) {
        Vec3 pos = positionData.getAsVector();
        Vec3 direction = extraData.getDirection();
        float yRot = (float)(Mth.atan2((double)direction.x, (double)direction.z) * 57.2957763671875);
        float yaw = (float)Math.toRadians(yRot);
        Vec3 left = new Vec3(-Math.cos(yaw), 0.0, Math.sin(yaw));
        Vec3 up = left.cross(direction);
        float scaleMultiplier = (float)(1.0 + Math.pow(random.nextFloat(), 2.0) * 0.5);
        WorldParticleBuilder.create((LodestoneWorldParticleType)((LodestoneWorldParticleType)MalumParticles.STAR.get())).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.5f, (float)0.07f, (float)0.0f).setEasing(Easing.SINE_IN, Easing.CIRC_IN).build()).setLifetime(15).setSpinData((SpinParticleDataWrapper)SpinParticleData.createRandomDirection((RandomSource)random, (float)Mth.nextFloat((RandomSource)random, (float)0.05f, (float)0.1f)).randomSpinOffset(random).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)(1.25f * scaleMultiplier), (float)0.5f, (float)0.0f).setEasing(Easing.EXPO_OUT, Easing.SINE_IN).build()).setColorData((ColorParticleDataWrapper)colorData.getColor()).setRandomOffset((double)0.2f).enableNoClip().setRandomMotion((double)0.02f, (double)0.02f).repeat(level, pos.x, pos.y, pos.z, 3).modifyScaleData(d -> d.multiplyValue(0.6f)).repeat(level, pos.x, pos.y, pos.z, 2);
        for (int i = 0; i < 16; ++i) {
            ColorParticleData color = colorData.getColor();
            float spread = RandomHelper.randomBetween((RandomSource)random, (float)0.1f, (float)0.2f);
            float speed = RandomHelper.randomBetween((RandomSource)random, (float)0.6f, (float)0.8f);
            float distance = -RandomHelper.randomBetween((RandomSource)random, (float)4.0f, (float)6.0f);
            float angle = (float)i / 16.0f * (float)Math.PI * 2.0f;
            Vec3 particleDirection = direction.add(left.scale(Math.sin(angle) * (double)spread)).add(up.scale(Math.cos(angle) * (double)spread)).normalize().scale((double)speed);
            Vec3 spawnPosition = pos.add(particleDirection.scale((double)distance));
            float lifetimeMultiplier = 0.7f;
            if (random.nextFloat() < 0.8f) {
                ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, spawnPosition, color);
                lightSpecs.getBuilder().multiplyLifetime(lifetimeMultiplier).enableForcedSpawn().modifyScaleData(d -> d.multiplyValue(1.25f)).setMotion(particleDirection);
                lightSpecs.getBloomBuilder().multiplyLifetime(lifetimeMultiplier).setMotion(particleDirection);
                lightSpecs.spawnParticles();
            }
            if (!(random.nextFloat() < 0.8f)) continue;
            ParticleEffectSpawner sparks = SparkParticleEffects.spiritMotionSparks(level, spawnPosition, color);
            sparks.getBuilder().multiplyLifetime(lifetimeMultiplier).enableForcedSpawn().setMotion(particleDirection.scale(1.5)).modifyScaleData(d -> d.multiplyValue(1.25f)).modifyLengthData(d -> d.multiplyValue(4.0f));
            sparks.getBloomBuilder().multiplyLifetime(lifetimeMultiplier).setMotion(particleDirection.scale(1.5));
            sparks.spawnParticles();
        }
    }

    public static void berserkerBlast(Level level, RandomSource random, NetworkedParticleEffectPositionData positionData, MalumNetworkedParticleEffectColorData colorData) {
        Vec3 pos = positionData.getAsVector();
        float scaleMultiplier = (float)(1.0 + Math.pow(random.nextFloat(), 2.0) * 0.5);
        WorldParticleBuilder.create((LodestoneWorldParticleType)((LodestoneWorldParticleType)MalumParticles.STAR.get())).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.4f, (float)0.07f, (float)0.0f).setEasing(Easing.SINE_IN, Easing.CIRC_IN).build()).setLifetime(12).setSpinData((SpinParticleDataWrapper)SpinParticleData.createRandomDirection((RandomSource)random, (float)Mth.nextFloat((RandomSource)random, (float)0.05f, (float)0.1f)).randomSpinOffset(random).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)(1.5f * scaleMultiplier), (float)0.5f, (float)0.0f).setEasing(Easing.EXPO_OUT, Easing.SINE_IN).build()).setColorData((ColorParticleDataWrapper)colorData.getColor()).setRandomOffset((double)0.2f).enableNoClip().setRandomMotion((double)0.02f, (double)0.02f).repeat(level, pos.x, pos.y, pos.z, 3).modifyScaleData(d -> d.multiplyValue(0.6f)).repeat(level, pos.x, pos.y, pos.z, 2);
        long gameTime = level.getGameTime();
        float time = 16.0f;
        for (int i = 0; i < 8; ++i) {
            Vec3 offsetTargetPosition = VecHelper.rotatingRadialOffset((Vec3)pos, (float)1.5f, (float)i, (float)8.0f, (float)gameTime, (float)time);
            float angleOffset = random.nextFloat() * 6.28f;
            Vec3 direction = pos.subtract(offsetTargetPosition).normalize();
            float yRot = (float)(Mth.atan2((double)direction.x, (double)direction.z) * 57.2957763671875);
            float yaw = (float)Math.toRadians(yRot);
            Vec3 left = new Vec3(-Math.cos(yaw), 0.0, Math.sin(yaw));
            Vec3 up = left.cross(direction);
            for (int j = 0; j < 3; ++j) {
                ColorParticleData color = colorData.getColor();
                float spread = RandomHelper.randomBetween((RandomSource)random, (float)0.1f, (float)0.2f);
                float speed = RandomHelper.randomBetween((RandomSource)random, (float)0.6f, (float)0.8f);
                float distance = -RandomHelper.randomBetween((RandomSource)random, (float)4.0f, (float)6.0f);
                float angle = angleOffset + (float)j / 3.0f * (float)Math.PI * 2.0f;
                Vec3 particleDirection = direction.add(left.scale(Math.sin(angle) * (double)spread)).add(up.scale(Math.cos(angle) * (double)spread)).normalize().scale((double)speed);
                Vec3 spawnPosition = pos.add(particleDirection.scale((double)distance));
                float lifetimeMultiplier = 0.4f;
                if (random.nextFloat() < 0.8f) {
                    ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, spawnPosition, color);
                    lightSpecs.getBuilder().multiplyLifetime(lifetimeMultiplier).enableForcedSpawn().modifyScaleData(d -> d.multiplyValue(1.75f)).setMotion(particleDirection);
                    lightSpecs.getBloomBuilder().multiplyLifetime(lifetimeMultiplier).setMotion(particleDirection);
                    lightSpecs.spawnParticles();
                }
                if (!(random.nextFloat() < 0.8f)) continue;
                ParticleEffectSpawner sparks = SparkParticleEffects.spiritMotionSparks(level, spawnPosition, color);
                sparks.getBuilder().multiplyLifetime(lifetimeMultiplier).enableForcedSpawn().setMotion(particleDirection.scale(1.5)).modifyScaleData(d -> d.multiplyValue(1.75f)).modifyLengthData(d -> d.multiplyValue(3.0f));
                sparks.getBloomBuilder().multiplyLifetime(lifetimeMultiplier).setMotion(particleDirection.scale(1.5));
                sparks.spawnParticles();
            }
        }
    }

    public static void highPriestShakenFaith(Level level, RandomSource random, NetworkedParticleEffectPositionData positionData, MalumNetworkedParticleEffectColorData colorData) {
        Vec3 pos = positionData.getAsVector();
        long gameTime = level.getGameTime();
        float time = 16.0f;
        for (int i = 0; i < 12; ++i) {
            Vec3 offsetTargetPosition = VecHelper.rotatingRadialOffset((Vec3)pos, (float)1.5f, (float)i, (float)12.0f, (float)gameTime, (float)time);
            double timeOffset = Math.cos((float)(gameTime + (long)(i * 480)) % time / time) * 0.25 - 0.25;
            offsetTargetPosition = offsetTargetPosition.add(0.0, timeOffset, 0.0);
            for (int j = 0; j < 3; ++j) {
                ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, offsetTargetPosition, colorData.getColor());
                float velocity = RandomHelper.randomBetween((RandomSource)random, (float)0.45f, (float)0.55f);
                Vec3 motion = offsetTargetPosition.subtract(pos).normalize().scale((double)(-velocity));
                lightSpecs.getBuilder().multiplyLifetime(0.6f).setMotion(motion).setLifeDelay(j * 3).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.2f, (float)0.8f, (float)0.0f).build()).modifyScaleData(d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)1.0f, (float)2.0f)));
                lightSpecs.getBloomBuilder().multiplyLifetime(0.6f).setMotion(motion).setLifeDelay(j * 3).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.05f, (float)0.35f, (float)0.0f).build()).modifyScaleData(d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)0.5f, (float)1.0f)));
                lightSpecs.spawnParticles();
            }
        }
    }

    public static void patienceRepaid(Level level, RandomSource random, NetworkedParticleEffectPositionData positionData, MalumNetworkedParticleEffectColorData colorData) {
        Vec3 pos = positionData.getAsVector();
        long gameTime = level.getGameTime();
        float time = 64.0f;
        for (int i = 0; i < 12; ++i) {
            for (int j = 0; j < 4; ++j) {
                Vec3 offsetTargetPosition = VecHelper.rotatingRadialOffset((Vec3)pos, (float)(1.25f - 0.05f * (float)j), (float)i, (float)12.0f, (float)(gameTime + (long)j), (float)time);
                ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, offsetTargetPosition, colorData.getColor());
                float velocity = 0.075f;
                Vec3 motion = offsetTargetPosition.subtract(pos).normalize().scale((double)(-velocity));
                lightSpecs.getBuilder().multiplyLifetime(0.8f).setMotion(motion).setLifeDelay(j * 2).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.2f, (float)0.8f, (float)0.0f).build()).modifyScaleData(d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)1.0f, (float)2.0f)));
                lightSpecs.getBloomBuilder().multiplyLifetime(0.8f).setMotion(motion).setLifeDelay(j * 2).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.05f, (float)0.35f, (float)0.0f).build()).modifyScaleData(d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)0.5f, (float)1.0f)));
                lightSpecs.spawnParticles();
            }
        }
    }

    public static void combustionBurn(Level level, RandomSource random, NetworkedParticleEffectPositionData positionData, MalumNetworkedParticleEffectColorData colorData) {
        Vec3 pos = positionData.getAsVector();
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 2; ++j) {
                Vec3 offsetTargetPosition = VecHelper.radialOffset((Vec3)pos, (float)(1.0f - (float)j * 0.1f), (float)i, (float)16.0f);
                ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, offsetTargetPosition, colorData.getColor());
                float velocity = 0.075f;
                int delay = (int)((float)(j * 2) + (float)i * 0.75f);
                lightSpecs.getBuilder().multiplyLifetime(0.8f).setMotion(0.0, (double)velocity, 0.0).setLifeDelay(delay).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.2f, (float)0.8f, (float)0.0f).build()).modifyScaleData(d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)1.0f, (float)2.0f)));
                lightSpecs.getBloomBuilder().multiplyLifetime(0.8f).setMotion(0.0, (double)velocity, 0.0).setLifeDelay(delay).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.05f, (float)0.35f, (float)0.0f).build()).modifyScaleData(d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)0.5f, (float)1.0f)));
                lightSpecs.spawnParticles();
            }
        }
    }

    public static void prospectorsGreedBurn(Level level, RandomSource random, NetworkedParticleEffectPositionData positionData, MalumNetworkedParticleEffectColorData colorData) {
        Vec3 pos = positionData.getAsVector();
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 6; ++j) {
                Vec3 offsetTargetPosition = VecHelper.radialOffset((Vec3)pos, (float)(1.4f - (float)j * 0.1f), (float)i, (float)8.0f);
                float velocity = RandomHelper.randomBetween((RandomSource)random, (float)0.01f, (float)0.02f);
                Vec3 motion = offsetTargetPosition.subtract(pos).normalize().scale((double)(-velocity));
                ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, offsetTargetPosition, colorData.getColor());
                int delay = j * 2;
                lightSpecs.getBuilder().setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.2f, (float)0.8f, (float)0.0f).build()).modifyScaleData(d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)1.0f, (float)2.0f))).multiplyLifetime(0.4f).setLifeDelay(delay).setFriction(2.0f).setMotion(motion);
                lightSpecs.getBloomBuilder().setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.05f, (float)0.35f, (float)0.0f).build()).modifyScaleData(d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)0.5f, (float)1.0f))).multiplyLifetime(0.4f).setLifeDelay(delay).setFriction(2.0f).setMotion(motion);
                lightSpecs.spawnParticles();
            }
        }
    }

    public static void wyrdReconstructionRevive(Level level, Entity entity, RandomSource random, NetworkedParticleEffectPositionData positionData, MalumNetworkedParticleEffectColorData colorData) {
        double posX = positionData.getPosX();
        double posY = positionData.getPosY();
        double posZ = positionData.getPosZ();
        Vec3 pos = new Vec3(posX, posY, posZ);
        Color smokeColor = new Color(45, 15, 15);
        for (int i = 0; i < 12; ++i) {
            Color primaryColor = colorData.getColor().getStartingColor();
            int lifetime = RandomHelper.randomBetween((RandomSource)random, (int)20, (int)40);
            boolean isAdditive = i % 2 == 0;
            float scale = (2.0f + (float)i * 0.5f) * (float)(isAdditive ? 1 : 2);
            LodestoneWorldParticleRenderType renderType = (isAdditive ? LodestoneWorldParticleRenderType.ADDITIVE : LodestoneWorldParticleRenderType.LUMITRANSPARENT).withDepthFade();
            float spin = RandomHelper.randomBetween((RandomSource)random, (float)0.04f, (float)0.08f);
            float randomOffset = (float)i * 0.2f;
            for (int j = 0; j < 2; ++j) {
                WorldParticleOptions options = new WorldParticleOptions(MalumParticles.GIANT_GLOWING_STAR);
                if (j == 1) {
                    options.setBehavior((LodestoneParticleBehavior)DirectionalParticleBehavior.directional());
                }
                WorldParticleBuilder.create((WorldParticleOptions)options).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.1f, (float)0.4f, (float)0.0f).build()).setColorData((ColorParticleDataWrapper)ColorParticleData.create((Color)primaryColor, (Color)smokeColor).setCoefficient(4.0f).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)(scale / 2.0f), (float)scale, (float)0.5f).setCoefficient(1.25f).setEasing(Easing.EXPO_OUT, Easing.EXPO_IN).build()).setSpinData((SpinParticleDataWrapper)SpinParticleData.createRandomDirection((RandomSource)random, (float)spin).build()).setRenderType((ParticleRenderType)renderType).setRandomOffset((double)randomOffset, 0.0).setMotion(0.0, (double)0.001f, 0.0).setLifetime(lifetime).enableNoClip().repeat(level, posX, posY - (double)0.3f, posZ, 2);
            }
        }
        int sparkCount = 64;
        float distance = 0.7f;
        long gameTime = level.getGameTime();
        Consumer<LodestoneWorldParticle> behavior = p -> {
            Vec3 offset = entity.position().add(0.0, (double)(entity.getBbHeight() / 2.0f), 0.0).subtract(p.getParticlePosition());
            if (offset.length() == 0.0) {
                offset = new Vec3(0.0, (double)0.02f, 0.0);
            }
            float delta = Math.max((float)p.getAge() / (float)p.getLifetime(), 0.0f) * 2.0f;
            float lerp = Easing.QUINTIC_IN.ease(delta, 0.0f, 0.3f);
            float velocity = Easing.CIRC_IN.ease((double)delta, 0.0, (double)0.3f + offset.length() * (double)0.6f);
            Vec3 speed = p.getParticleSpeed().lerp(offset.normalize().scale((double)velocity), (double)lerp);
            p.setParticleSpeed(speed);
        };
        for (int i = 0; i < sparkCount; ++i) {
            ColorParticleData color = colorData.getColor();
            Color primaryColor = color.getStartingColor();
            Color secondaryColor = color.getEndingColor();
            Vec3 offsetPosition = VecHelper.rotatingRadialOffset((Vec3)pos, (float)distance, (float)i, (float)sparkCount, (float)gameTime, (float)320.0f);
            float motionFactor = RandomHelper.randomBetween((RandomSource)random, (float)0.06f, (float)0.12f);
            int lifetime = RandomHelper.randomBetween((RandomSource)random, (int)20, (int)40);
            Vec3 motion = offsetPosition.subtract(pos).normalize().scale((double)motionFactor);
            distance += 0.03f;
            gameTime += 10L;
            for (int j = 0; j < 12; ++j) {
                boolean isAdditive = j % 2 == 0;
                Color start = isAdditive ? primaryColor : secondaryColor;
                Color end = isAdditive ? secondaryColor : smokeColor;
                float lengthMultiplier = (isAdditive ? 0.5f : 1.0f) * RandomHelper.randomBetween((RandomSource)random, (float)0.4f, (float)1.8f);
                float scaleMultiplier = (isAdditive ? 1.75f : 5.5f) * RandomHelper.randomBetween((RandomSource)random, (float)0.4f, (float)1.8f);
                float alphaMultiplier = isAdditive ? 1.5f : 3.0f;
                float colorCoefficient = isAdditive ? 1.0f : 1.75f;
                LodestoneWorldParticleRenderType renderType = isAdditive ? LodestoneWorldParticleRenderType.ADDITIVE : LodestoneWorldParticleRenderType.LUMITRANSPARENT;
                LodestoneRenderLayer renderTarget = isAdditive ? LodestoneRenderHandler.LATE_DEFERRED_RENDER : LodestoneRenderHandler.DEFERRED_RENDER;
                WorldParticleBuilder.create((WorldParticleOptions)new WorldParticleOptions(MalumParticles.GIANT_GLOWING_STAR)).setBehavior((LodestoneParticleBehavior)SparkParticleBehavior.sparkBehavior().setForcedDirection(new Vec3(0.0, 1.0, 0.0))).setLengthData((GenericParticleDataWrapper)GenericParticleData.create((float)0.1f, (float)0.6f, (float)0.3f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN_OUT).setCoefficient(1.25f).build().multiplyValue(lengthMultiplier)).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)0.025f, (float)0.25f, (float)0.6f).build().multiplyValue(scaleMultiplier)).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.8f, (float)0.0f).build().multiplyValue(alphaMultiplier)).setColorData((ColorParticleDataWrapper)ColorParticleData.create((Color)start, (Color)end).setCoefficient(colorCoefficient).build()).setSpritePicker(SimpleParticleOptions.ParticleSpritePicker.WITH_AGE).setRenderTarget(renderTarget).setRenderType((ParticleRenderType)renderType).setLifeDelay(j + i / 2).addTickActor(behavior).setLifetime(lifetime).enableNoClip().setMotion(motion).spawn(level, offsetPosition.x, offsetPosition.y, offsetPosition.z);
            }
        }
    }

    public static void invertedHeartDamageEffect(Level level, RandomSource random, NetworkedParticleEffectPositionData positionData, MalumNetworkedParticleEffectColorData colorData) {
        double posX = positionData.getPosX();
        double posY = positionData.getPosY();
        double posZ = positionData.getPosZ();
        Vec3 pos = new Vec3(posX, posY, posZ);
        Vec3 directionToPlayer = Minecraft.getInstance().player.getEyePosition().subtract(pos).normalize();
        Vec3 behindPos = pos.subtract(directionToPlayer.scale(2.0));
        Vec3 inFrontPos = pos.add(directionToPlayer.scale(0.75));
        for (int i = 0; i < 3; ++i) {
            ColorParticleData color = colorData.getColor();
            SpinParticleData spinData = SpinParticleData.createRandomDirection((RandomSource)random, (float)Mth.nextFloat((RandomSource)random, (float)0.15f, (float)0.3f)).randomSpinOffset(random).build();
            float scaleMultiplier = RandomHelper.randomBetween((RandomSource)random, (float)0.5f, (float)1.0f);
            WorldParticleBuilder.create((LodestoneWorldParticleType)((LodestoneWorldParticleType)MalumParticles.SHINE.get())).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)(0.8f * scaleMultiplier), (float)0.25f, (float)0.0f).setEasing(Easing.EXPO_OUT, Easing.SINE_IN).build()).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.6f, (float)0.07f, (float)0.0f).setEasing(Easing.SINE_IN, Easing.CIRC_IN).build()).setSpritePicker(SimpleParticleOptions.ParticleSpritePicker.WITH_AGE).setLifetime(RandomHelper.randomBetween((RandomSource)random, (int)5, (int)15)).setRandomMotion((double)0.02f, (double)0.02f).setColorData((ColorParticleDataWrapper)color).setSpinData((SpinParticleDataWrapper)spinData).setRandomOffset(1.0).enableNoClip().repeat(level, inFrontPos.x, inFrontPos.y, inFrontPos.z, 2);
            WorldParticleBuilder.create((LodestoneWorldParticleType)((LodestoneWorldParticleType)MalumParticles.GIANT_GLOWING_STAR.get())).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)(5.0f * scaleMultiplier), (float)0.25f, (float)0.0f).setEasing(Easing.SINE_IN, Easing.SINE_IN).build()).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)0.4f, (float)0.07f, (float)0.0f).setEasing(Easing.SINE_IN, Easing.CIRC_IN).build()).setColorData((ColorParticleDataWrapper)color.invert().build()).setLifetime(RandomHelper.randomBetween((RandomSource)random, (int)10, (int)20)).setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT).setRandomMotion((double)0.02f, (double)0.02f).setSpinData((SpinParticleDataWrapper)spinData).setRandomOffset(1.0).enableNoClip().repeat(level, behindPos.x, behindPos.y, behindPos.z, 1);
        }
    }
}

