/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.mixin;

import com.sammy.malum.common.data.attachment.AvariceMarkData;
import com.sammy.malum.common.entity.nitrate.AbstractNitrateEntity;
import com.sammy.malum.common.geas.pact.infernal.BlastweaverGeas;
import com.sammy.malum.common.geas.pact.infernal.ProspectorGeas;
import com.sammy.malum.common.item.curiosities.curios.sets.prospector.CurioDemolitionistRing;
import com.sammy.malum.common.item.curiosities.curios.sets.prospector.CurioHoarderRing;
import com.sammy.malum.common.item.curiosities.curios.sets.prospector.CurioProspectorBelt;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Explosion.class})
public abstract class ExplosionMixin {
    @Unique
    boolean malum$hasHoarderRing;
    @Unique
    boolean malum$hasProspectorBelt;
    @Unique
    boolean malum$hasProspectorGeas;
    @Mutable
    @Shadow
    @Final
    private float radius;

    @Shadow
    @Nullable
    public abstract LivingEntity getIndirectSourceEntity();

    @Inject(method={"<init>(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/damagesource/DamageSource;Lnet/minecraft/world/level/ExplosionDamageCalculator;DDDFZLnet/minecraft/world/level/Explosion$BlockInteraction;Lnet/minecraft/core/particles/ParticleOptions;Lnet/minecraft/core/particles/ParticleOptions;Lnet/minecraft/core/Holder;)V"}, at={@At(value="RETURN")})
    private void malum$modifyExplosion(Level level, Entity source, DamageSource damageSource, ExplosionDamageCalculator damageCalculator, double x, double y, double z, float radius, boolean fire, Explosion.BlockInteraction blockInteraction, ParticleOptions smallExplosionParticles, ParticleOptions largeExplosionParticles, Holder explosionSound, CallbackInfo ci) {
        LivingEntity sourceEntity = this.getIndirectSourceEntity();
        this.radius = CurioDemolitionistRing.increaseExplosionRadius(sourceEntity, radius);
        this.radius = BlastweaverGeas.increaseExplosionRadius(sourceEntity, radius);
    }

    @Inject(method={"finalizeExplosion"}, at={@At(value="HEAD")})
    private void malum$CacheHoarderRing(boolean pSpawnParticles, CallbackInfo ci) {
        LivingEntity entity = this.getIndirectSourceEntity();
        if (entity != null) {
            this.malum$hasHoarderRing = CurioHoarderRing.hasHoarderRing(entity);
            this.malum$hasProspectorBelt = CurioProspectorBelt.hasProspectorBelt(entity);
            this.malum$hasProspectorGeas = ProspectorGeas.hasProspectorPact(entity);
        }
    }

    @Redirect(method={"finalizeExplosion"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/Block;popResource(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/item/ItemStack;)V"))
    private void malum$popResource(Level level, BlockPos pos, ItemStack stack) {
        pos = CurioHoarderRing.getExplosionPos(this.malum$hasHoarderRing, pos, this.getIndirectSourceEntity(), stack);
        if (this.malum$hasProspectorBelt || this.malum$hasProspectorGeas) {
            int avarice = AvariceMarkData.getAppliedAvarice(this.getIndirectSourceEntity());
            AvariceMarkData.popResourceAndMarkEntity(level, pos, stack, avarice);
        } else {
            Block.popResource((Level)level, (BlockPos)pos, (ItemStack)stack);
        }
    }

    @Inject(method={"getIndirectSourceEntityInternal"}, at={@At(value="HEAD")}, cancellable=true)
    private static void malum$modifyIndirectSourceEntity(Entity source, CallbackInfoReturnable<LivingEntity> cir) {
        AbstractNitrateEntity.getOwnerFromExplosion(source).ifPresent(arg_0 -> cir.setReturnValue(arg_0));
    }
}

