/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.datagen.worldgen;

import com.sammy.malum.common.worldgen.well.WeepingWellStructure;
import com.sammy.malum.registry.common.MalumTags;
import com.sammy.malum.registry.common.worldgen.MalumStructures;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;

public class StructureDatagen {
    public static void structureBootstrap(BootstrapContext<Structure> context) {
        context.register(MalumStructures.StructureKeys.WEEPING_WELL_STRUCTURE_KEY, (Object)new WeepingWellStructure(StructureDatagen.structure((HolderSet<Biome>)context.lookup(Registries.BIOME).getOrThrow(MalumTags.BiomeTags.HAS_WEEPING_WELL), GenerationStep.Decoration.UNDERGROUND_STRUCTURES, TerrainAdjustment.NONE)));
    }

    public static void structureSetBootstrap(BootstrapContext<StructureSet> context) {
        context.register(MalumStructures.StructureKeys.WEEPING_WELL_STRUCTURE_SET_KEY, (Object)new StructureSet(List.of(StructureSet.entry((Holder)context.lookup(Registries.STRUCTURE).getOrThrow(MalumStructures.StructureKeys.WEEPING_WELL_STRUCTURE_KEY))), (StructurePlacement)new RandomSpreadStructurePlacement(24, 18, RandomSpreadType.TRIANGULAR, 546451665)));
    }

    private static Structure.StructureSettings structure(HolderSet<Biome> tag, TerrainAdjustment adj) {
        return new Structure.StructureSettings(tag, Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, adj);
    }

    private static Structure.StructureSettings structure(HolderSet<Biome> tag, Map<MobCategory, StructureSpawnOverride> spawnOverrides, TerrainAdjustment adj) {
        return new Structure.StructureSettings(tag, spawnOverrides, GenerationStep.Decoration.SURFACE_STRUCTURES, adj);
    }

    private static Structure.StructureSettings structure(HolderSet<Biome> tag, GenerationStep.Decoration decoration, TerrainAdjustment adj) {
        return new Structure.StructureSettings(tag, Map.of(), decoration, adj);
    }

    private static JigsawStructure createJigsaw(Structure.StructureSettings settings, Holder<StructureTemplatePool> startPool, int maxDepth, HeightProvider startHeight, Heightmap.Types projectStartToHeightmap) {
        return new JigsawStructure(settings, startPool, maxDepth, startHeight, false, projectStartToHeightmap);
    }

    private static JigsawStructure createJigsawWithExpansion(Structure.StructureSettings settings, Holder<StructureTemplatePool> startPool, int maxDepth, HeightProvider startHeight, Heightmap.Types projectStartToHeightmap) {
        return new JigsawStructure(settings, startPool, maxDepth, startHeight, true, projectStartToHeightmap);
    }

    @FunctionalInterface
    public static interface StructureFactory {
        public Structure generate(BootstrapContext<Structure> var1);
    }
}

