/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.datagen.recipe.crafting;

import com.sammy.malum.datagen.recipe.MalumVanillaRecipes;
import com.sammy.malum.datagen.tag.MalumItemTagDatagen;
import com.sammy.malum.registry.common.MalumTags;
import com.sammy.malum.registry.common.item.MalumItems;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class MalumRockSetDatagen {
    private static final MalumDatagenRockSet TAINTED_ROCK = new MalumDatagenRockSet("tainted_rock", (Item)MalumItems.TAINTED_ROCK.get(), (Item)MalumItems.SMOOTH_TAINTED_ROCK.get(), (Item)MalumItems.POLISHED_TAINTED_ROCK.get(), (Item)MalumItems.TAINTED_ROCK_STAIRS.get(), (Item)MalumItems.SMOOTH_TAINTED_ROCK_STAIRS.get(), (Item)MalumItems.POLISHED_TAINTED_ROCK_STAIRS.get(), (Item)MalumItems.TAINTED_ROCK_SLAB.get(), (Item)MalumItems.SMOOTH_TAINTED_ROCK_SLAB.get(), (Item)MalumItems.POLISHED_TAINTED_ROCK_SLAB.get(), (Item)MalumItems.TAINTED_ROCK_BRICKS.get(), (Item)MalumItems.TAINTED_ROCK_TILES.get(), (Item)MalumItems.SMALL_TAINTED_ROCK_BRICKS.get(), (Item)MalumItems.TAINTED_ROCK_BRICKS_STAIRS.get(), (Item)MalumItems.TAINTED_ROCK_TILES_STAIRS.get(), (Item)MalumItems.SMALL_TAINTED_ROCK_BRICKS_STAIRS.get(), (Item)MalumItems.TAINTED_ROCK_BRICKS_SLAB.get(), (Item)MalumItems.TAINTED_ROCK_TILES_SLAB.get(), (Item)MalumItems.SMALL_TAINTED_ROCK_BRICKS_SLAB.get(), (Item)MalumItems.RUNIC_TAINTED_ROCK_BRICKS.get(), (Item)MalumItems.RUNIC_TAINTED_ROCK_TILES.get(), (Item)MalumItems.RUNIC_SMALL_TAINTED_ROCK_BRICKS.get(), (Item)MalumItems.RUNIC_TAINTED_ROCK_BRICKS_STAIRS.get(), (Item)MalumItems.RUNIC_TAINTED_ROCK_TILES_STAIRS.get(), (Item)MalumItems.RUNIC_SMALL_TAINTED_ROCK_BRICKS_STAIRS.get(), (Item)MalumItems.RUNIC_TAINTED_ROCK_BRICKS_SLAB.get(), (Item)MalumItems.RUNIC_TAINTED_ROCK_TILES_SLAB.get(), (Item)MalumItems.RUNIC_SMALL_TAINTED_ROCK_BRICKS_SLAB.get(), (Item)MalumItems.TAINTED_ROCK_WALL.get(), (Item)MalumItems.SMOOTH_TAINTED_ROCK_WALL.get(), (Item)MalumItems.POLISHED_TAINTED_ROCK_WALL.get(), (Item)MalumItems.TAINTED_ROCK_BRICKS_WALL.get(), (Item)MalumItems.TAINTED_ROCK_TILES_WALL.get(), (Item)MalumItems.SMALL_TAINTED_ROCK_BRICKS_WALL.get(), (Item)MalumItems.RUNIC_TAINTED_ROCK_BRICKS_WALL.get(), (Item)MalumItems.RUNIC_TAINTED_ROCK_TILES_WALL.get(), (Item)MalumItems.RUNIC_SMALL_TAINTED_ROCK_BRICKS_WALL.get(), (Item)MalumItems.TAINTED_ROCK_COLUMN.get(), (Item)MalumItems.TAINTED_ROCK_COLUMN_CAP.get(), (Item)MalumItems.CUT_TAINTED_ROCK.get(), (Item)MalumItems.CHECKERED_TAINTED_ROCK.get(), (Item)MalumItems.CHISELED_TAINTED_ROCK.get(), (Item)MalumItems.TAINTED_ROCK_PRESSURE_PLATE.get(), (Item)MalumItems.TAINTED_ROCK_BUTTON.get(), (Item)MalumItems.TAINTED_ROCK_ITEM_STAND.get(), (Item)MalumItems.TAINTED_ROCK_ITEM_PEDESTAL.get(), MalumTags.ItemTags.TAINTED_ROCK, MalumTags.ItemTags.TAINTED_BLOCKS, MalumTags.ItemTags.TAINTED_STAIRS, MalumTags.ItemTags.TAINTED_SLABS, MalumTags.ItemTags.TAINTED_WALLS);
    private static final MalumDatagenRockSet TWISTED_ROCK = new MalumDatagenRockSet("twisted_rock", (Item)MalumItems.TWISTED_ROCK.get(), (Item)MalumItems.SMOOTH_TWISTED_ROCK.get(), (Item)MalumItems.POLISHED_TWISTED_ROCK.get(), (Item)MalumItems.TWISTED_ROCK_STAIRS.get(), (Item)MalumItems.SMOOTH_TWISTED_ROCK_STAIRS.get(), (Item)MalumItems.POLISHED_TWISTED_ROCK_STAIRS.get(), (Item)MalumItems.TWISTED_ROCK_SLAB.get(), (Item)MalumItems.SMOOTH_TWISTED_ROCK_SLAB.get(), (Item)MalumItems.POLISHED_TWISTED_ROCK_SLAB.get(), (Item)MalumItems.TWISTED_ROCK_BRICKS.get(), (Item)MalumItems.TWISTED_ROCK_TILES.get(), (Item)MalumItems.SMALL_TWISTED_ROCK_BRICKS.get(), (Item)MalumItems.TWISTED_ROCK_BRICKS_STAIRS.get(), (Item)MalumItems.TWISTED_ROCK_TILES_STAIRS.get(), (Item)MalumItems.SMALL_TWISTED_ROCK_BRICKS_STAIRS.get(), (Item)MalumItems.TWISTED_ROCK_BRICKS_SLAB.get(), (Item)MalumItems.TWISTED_ROCK_TILES_SLAB.get(), (Item)MalumItems.SMALL_TWISTED_ROCK_BRICKS_SLAB.get(), (Item)MalumItems.RUNIC_TWISTED_ROCK_BRICKS.get(), (Item)MalumItems.RUNIC_TWISTED_ROCK_TILES.get(), (Item)MalumItems.RUNIC_SMALL_TWISTED_ROCK_BRICKS.get(), (Item)MalumItems.RUNIC_TWISTED_ROCK_BRICKS_STAIRS.get(), (Item)MalumItems.RUNIC_TWISTED_ROCK_TILES_STAIRS.get(), (Item)MalumItems.RUNIC_SMALL_TWISTED_ROCK_BRICKS_STAIRS.get(), (Item)MalumItems.RUNIC_TWISTED_ROCK_BRICKS_SLAB.get(), (Item)MalumItems.RUNIC_TWISTED_ROCK_TILES_SLAB.get(), (Item)MalumItems.RUNIC_SMALL_TWISTED_ROCK_BRICKS_SLAB.get(), (Item)MalumItems.TWISTED_ROCK_WALL.get(), (Item)MalumItems.SMOOTH_TWISTED_ROCK_WALL.get(), (Item)MalumItems.POLISHED_TWISTED_ROCK_WALL.get(), (Item)MalumItems.TWISTED_ROCK_BRICKS_WALL.get(), (Item)MalumItems.TWISTED_ROCK_TILES_WALL.get(), (Item)MalumItems.SMALL_TWISTED_ROCK_BRICKS_WALL.get(), (Item)MalumItems.RUNIC_TWISTED_ROCK_BRICKS_WALL.get(), (Item)MalumItems.RUNIC_TWISTED_ROCK_TILES_WALL.get(), (Item)MalumItems.RUNIC_SMALL_TWISTED_ROCK_BRICKS_WALL.get(), (Item)MalumItems.TWISTED_ROCK_COLUMN.get(), (Item)MalumItems.TWISTED_ROCK_COLUMN_CAP.get(), (Item)MalumItems.CUT_TWISTED_ROCK.get(), (Item)MalumItems.CHECKERED_TWISTED_ROCK.get(), (Item)MalumItems.CHISELED_TWISTED_ROCK.get(), (Item)MalumItems.TWISTED_ROCK_PRESSURE_PLATE.get(), (Item)MalumItems.TWISTED_ROCK_BUTTON.get(), (Item)MalumItems.TWISTED_ROCK_ITEM_STAND.get(), (Item)MalumItems.TWISTED_ROCK_ITEM_PEDESTAL.get(), MalumTags.ItemTags.TWISTED_ROCK, MalumTags.ItemTags.TWISTED_BLOCKS, MalumTags.ItemTags.TWISTED_STAIRS, MalumTags.ItemTags.TWISTED_SLABS, MalumTags.ItemTags.TWISTED_WALLS);
    private static MalumDatagenRockSet cachedRockSet;

    public static void addTags(MalumItemTagDatagen provider) {
        MalumRockSetDatagen.addTags(provider, TAINTED_ROCK);
        MalumRockSetDatagen.addTags(provider, TWISTED_ROCK);
    }

    public static void buildRecipes(RecipeOutput consumer) {
        MalumRockSetDatagen.buildRecipes(consumer, TAINTED_ROCK);
        MalumRockSetDatagen.buildRecipes(consumer, TWISTED_ROCK);
    }

    protected static void addTags(MalumItemTagDatagen provider, MalumDatagenRockSet rockSet) {
        provider.safeCopy(rockSet.setEncompassingTag);
        provider.safeCopy(rockSet.blockTag);
        provider.safeCopy(rockSet.stairTag);
        provider.safeCopy(rockSet.slabTag);
        provider.safeCopy(rockSet.wallTag);
    }

    protected static void buildRecipes(RecipeOutput recipeOutput, MalumDatagenRockSet rockSet) {
        Criterion<InventoryChangeTrigger.TriggerInstance> condition = MalumVanillaRecipes.has((ItemLike)rockSet.rock);
        cachedRockSet = rockSet;
        MalumRockSetDatagen.shapedSlab(recipeOutput, (ItemLike)rockSet.rockSlab, rockSet.rock);
        MalumRockSetDatagen.shapedSlab(recipeOutput, (ItemLike)rockSet.smoothRockSlab, rockSet.smoothRock);
        MalumRockSetDatagen.shapedSlab(recipeOutput, (ItemLike)rockSet.polishedRockSlab, rockSet.polishedRock);
        MalumRockSetDatagen.shapedStairs(recipeOutput, (ItemLike)rockSet.rockStairs, rockSet.rock);
        MalumRockSetDatagen.shapedStairs(recipeOutput, (ItemLike)rockSet.smoothRockStairs, rockSet.smoothRock);
        MalumRockSetDatagen.shapedStairs(recipeOutput, (ItemLike)rockSet.polishedRockStairs, rockSet.polishedRock);
        MalumRockSetDatagen.shapedWall(recipeOutput, (ItemLike)rockSet.rockWall, rockSet.rock);
        MalumRockSetDatagen.shapedWall(recipeOutput, (ItemLike)rockSet.smoothRockWall, rockSet.smoothRock);
        MalumRockSetDatagen.shapedWall(recipeOutput, (ItemLike)rockSet.polishedRockWall, rockSet.polishedRock);
        MalumRockSetDatagen.shapedSlab(recipeOutput, (ItemLike)rockSet.bricksSlab, rockSet.bricks);
        MalumRockSetDatagen.shapedSlab(recipeOutput, (ItemLike)rockSet.tilesSlab, rockSet.tiles);
        MalumRockSetDatagen.shapedSlab(recipeOutput, (ItemLike)rockSet.smallBricksSlab, rockSet.smallBricks);
        MalumRockSetDatagen.shapedStairs(recipeOutput, (ItemLike)rockSet.bricksStairs, rockSet.bricks);
        MalumRockSetDatagen.shapedStairs(recipeOutput, (ItemLike)rockSet.tilesStairs, rockSet.tiles);
        MalumRockSetDatagen.shapedStairs(recipeOutput, (ItemLike)rockSet.smallBricksStairs, rockSet.smallBricks);
        MalumRockSetDatagen.shapedWall(recipeOutput, (ItemLike)rockSet.bricksWall, rockSet.bricks);
        MalumRockSetDatagen.shapedWall(recipeOutput, (ItemLike)rockSet.tilesWall, rockSet.tiles);
        MalumRockSetDatagen.shapedWall(recipeOutput, (ItemLike)rockSet.smallBricksWall, rockSet.smallBricks);
        MalumRockSetDatagen.shapedSlab(recipeOutput, (ItemLike)rockSet.runicBricksSlab, rockSet.runicBricks);
        MalumRockSetDatagen.shapedSlab(recipeOutput, (ItemLike)rockSet.runicTilesSlab, rockSet.runicTiles);
        MalumRockSetDatagen.shapedSlab(recipeOutput, (ItemLike)rockSet.runicSmallBricksSlab, rockSet.runicSmallBricks);
        MalumRockSetDatagen.shapedStairs(recipeOutput, (ItemLike)rockSet.runicBricksStairs, rockSet.runicBricks);
        MalumRockSetDatagen.shapedStairs(recipeOutput, (ItemLike)rockSet.runicTilesStairs, rockSet.runicTiles);
        MalumRockSetDatagen.shapedStairs(recipeOutput, (ItemLike)rockSet.runicSmallBricksStairs, rockSet.runicSmallBricks);
        MalumRockSetDatagen.shapedWall(recipeOutput, (ItemLike)rockSet.runicBricksWall, rockSet.bricks);
        MalumRockSetDatagen.shapedWall(recipeOutput, (ItemLike)rockSet.runicTilesWall, rockSet.tiles);
        MalumRockSetDatagen.shapedWall(recipeOutput, (ItemLike)rockSet.runicSmallBricksWall, rockSet.smallBricks);
        MalumRockSetDatagen.rockExchange(recipeOutput, (ItemLike)rockSet.bricks, (ItemLike)rockSet.rock);
        MalumRockSetDatagen.rockExchange(recipeOutput, (ItemLike)rockSet.tiles, (ItemLike)rockSet.bricks);
        MalumRockSetDatagen.rockExchange(recipeOutput, (ItemLike)rockSet.smallBricks, (ItemLike)rockSet.tiles);
        MalumRockSetDatagen.rockExchange(recipeOutput, (ItemLike)rockSet.bricks, (ItemLike)rockSet.smallBricks);
        MalumRockSetDatagen.runicExchange(recipeOutput, (ItemLike)rockSet.runicBricks, (ItemLike)rockSet.bricks);
        MalumRockSetDatagen.runicExchange(recipeOutput, (ItemLike)rockSet.runicTiles, (ItemLike)rockSet.tiles);
        MalumRockSetDatagen.runicExchange(recipeOutput, (ItemLike)rockSet.runicSmallBricks, (ItemLike)rockSet.smallBricks);
        MalumRockSetDatagen.rockExchange(recipeOutput, (ItemLike)rockSet.runicTiles, (ItemLike)rockSet.runicBricks);
        MalumRockSetDatagen.rockExchange(recipeOutput, (ItemLike)rockSet.runicSmallBricks, (ItemLike)rockSet.runicTiles);
        MalumRockSetDatagen.rockExchange(recipeOutput, (ItemLike)rockSet.runicBricks, (ItemLike)rockSet.runicSmallBricks);
        MalumRockSetDatagen.shapelessButton(recipeOutput, (ItemLike)rockSet.button, rockSet.rock);
        MalumRockSetDatagen.shapedPressurePlate(recipeOutput, (ItemLike)rockSet.pressurePlate, rockSet.rock);
        MalumRockSetDatagen.runicExchange(recipeOutput, (ItemLike)rockSet.smoothRock, (ItemLike)rockSet.rock);
        MalumRockSetDatagen.rockExchange(recipeOutput, (ItemLike)rockSet.polishedRock, (ItemLike)rockSet.smoothRock);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)rockSet.chiseledRock, (int)1).define(Character.valueOf('#'), (ItemLike)rockSet.polishedRockSlab).pattern("#").pattern("#").unlockedBy("has_input", condition).save(recipeOutput);
        MalumRockSetDatagen.stoneCutting(recipeOutput, (ItemLike)rockSet.rock, (ItemLike)rockSet.chiseledRock);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)rockSet.cutRock, (int)2).define(Character.valueOf('X'), (ItemLike)rockSet.polishedRock).define(Character.valueOf('Y'), (ItemLike)rockSet.rock).pattern("X").pattern("Y").unlockedBy("has_input", condition).save(recipeOutput);
        MalumRockSetDatagen.stoneCutting(recipeOutput, (ItemLike)rockSet.rock, (ItemLike)rockSet.cutRock);
        MalumRockSetDatagen.stoneCutting(recipeOutput, (ItemLike)rockSet.polishedRock, (ItemLike)rockSet.cutRock);
        MalumRockSetDatagen.runicExchange(recipeOutput, (ItemLike)rockSet.checkeredRock, (ItemLike)rockSet.cutRock);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)rockSet.column, (int)3).define(Character.valueOf('#'), (ItemLike)rockSet.rock).pattern("#").pattern("#").pattern("#").unlockedBy("has_input", condition).save(recipeOutput);
        MalumRockSetDatagen.stoneCutting(recipeOutput, (ItemLike)rockSet.rock, (ItemLike)rockSet.column);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)rockSet.columnCap, (int)2).define(Character.valueOf('X'), (ItemLike)rockSet.polishedRock).define(Character.valueOf('Y'), (ItemLike)rockSet.column).pattern("X").pattern("Y").unlockedBy("has_input", condition).save(recipeOutput);
        MalumRockSetDatagen.stoneCutting(recipeOutput, (ItemLike)rockSet.rock, (ItemLike)rockSet.columnCap);
        MalumRockSetDatagen.stoneCutting(recipeOutput, (ItemLike)rockSet.polishedRock, (ItemLike)rockSet.columnCap);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)rockSet.itemStand, (int)2).define(Character.valueOf('X'), (ItemLike)rockSet.rock).define(Character.valueOf('Y'), (ItemLike)rockSet.rockSlab).pattern("YYY").pattern("XXX").unlockedBy("has_input", condition).save(recipeOutput);
        MalumRockSetDatagen.stoneCutting(recipeOutput, (ItemLike)rockSet.rock, (ItemLike)rockSet.itemStand);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)rockSet.itemPedestal).define(Character.valueOf('X'), (ItemLike)rockSet.rock).define(Character.valueOf('Y'), (ItemLike)rockSet.rockSlab).pattern("YYY").pattern(" X ").pattern("YYY").unlockedBy("has_input", condition).save(recipeOutput);
        MalumRockSetDatagen.stoneCutting(recipeOutput, (ItemLike)rockSet.rock, (ItemLike)rockSet.itemPedestal);
    }

    private static void rockExchange(RecipeOutput recipeOutput, ItemLike output, ItemLike input) {
        ResourceLocation recipeID = RecipeBuilder.getDefaultRecipeId((ItemLike)output).withSuffix("_from_" + RecipeBuilder.getDefaultRecipeId((ItemLike)input).getPath());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)4).define(Character.valueOf('#'), input).pattern("##").pattern("##").unlockedBy("has_input", MalumVanillaRecipes.has(input)).save(recipeOutput, recipeID);
        MalumRockSetDatagen.stoneCutting(recipeOutput, input, output);
    }

    private static void runicExchange(RecipeOutput recipeOutput, ItemLike output, ItemLike input) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{input}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)0.1f, (int)200).unlockedBy("has_input", MalumVanillaRecipes.has(input)).save(recipeOutput);
        MalumRockSetDatagen.stoneCutting(recipeOutput, input, output);
    }

    private static void shapelessButton(RecipeOutput recipeOutput, ItemLike button, Item input) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)button).requires((ItemLike)input).unlockedBy("has_input", MalumVanillaRecipes.has((ItemLike)input)).save(recipeOutput);
        MalumRockSetDatagen.stoneCutting(recipeOutput, (ItemLike)input, button);
    }

    private static void shapedPressurePlate(RecipeOutput recipeOutput, ItemLike pressurePlate, Item input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)pressurePlate).define(Character.valueOf('#'), (ItemLike)input).pattern("##").unlockedBy("has_input", MalumVanillaRecipes.has((ItemLike)input)).save(recipeOutput);
        MalumRockSetDatagen.stoneCutting(recipeOutput, (ItemLike)input, pressurePlate);
    }

    private static void shapedSlab(RecipeOutput recipeOutput, ItemLike slab, Item input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)slab, (int)6).define(Character.valueOf('#'), (ItemLike)input).pattern("###").unlockedBy("has_input", MalumVanillaRecipes.has((ItemLike)input)).save(recipeOutput);
        MalumRockSetDatagen.stoneCutting(recipeOutput, (ItemLike)input, slab, 2);
        if (!input.equals(MalumRockSetDatagen.cachedRockSet.rock)) {
            MalumRockSetDatagen.stoneCutting(recipeOutput, (ItemLike)MalumRockSetDatagen.cachedRockSet.rock, slab, 2);
        }
    }

    private static void shapedStairs(RecipeOutput recipeOutput, ItemLike stairs, Item input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)stairs, (int)4).define(Character.valueOf('#'), (ItemLike)input).pattern("#  ").pattern("## ").pattern("###").unlockedBy("has_input", MalumVanillaRecipes.has((ItemLike)input)).save(recipeOutput);
        MalumRockSetDatagen.stoneCutting(recipeOutput, (ItemLike)input, stairs);
        if (!input.equals(MalumRockSetDatagen.cachedRockSet.rock)) {
            MalumRockSetDatagen.stoneCutting(recipeOutput, (ItemLike)MalumRockSetDatagen.cachedRockSet.rock, stairs);
        }
    }

    private static void shapedWall(RecipeOutput recipeOutput, ItemLike wall, Item input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)wall, (int)6).define(Character.valueOf('#'), (ItemLike)input).pattern("###").pattern("###").unlockedBy("has_input", MalumVanillaRecipes.has((ItemLike)input)).save(recipeOutput);
        MalumRockSetDatagen.stoneCutting(recipeOutput, (ItemLike)input, wall, 1);
        if (!input.equals(MalumRockSetDatagen.cachedRockSet.rock)) {
            MalumRockSetDatagen.stoneCutting(recipeOutput, (ItemLike)MalumRockSetDatagen.cachedRockSet.rock, wall, 1);
        }
    }

    private static void stoneCutting(RecipeOutput recipeOutput, ItemLike input, ItemLike output) {
        MalumRockSetDatagen.stoneCutting(recipeOutput, input, output, 1);
    }

    private static void stoneCutting(RecipeOutput recipeOutput, ItemLike input, ItemLike output, int outputCount) {
        ResourceLocation recipeID = RecipeBuilder.getDefaultRecipeId((ItemLike)output).withSuffix("_stonecutting_from_" + RecipeBuilder.getDefaultRecipeId((ItemLike)input).getPath());
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{input}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)outputCount).unlockedBy("has_input", MalumVanillaRecipes.has(input)).save(recipeOutput, recipeID);
    }

    public record MalumDatagenRockSet(String prefix, Item rock, Item smoothRock, Item polishedRock, Item rockStairs, Item smoothRockStairs, Item polishedRockStairs, Item rockSlab, Item smoothRockSlab, Item polishedRockSlab, Item bricks, Item tiles, Item smallBricks, Item bricksStairs, Item tilesStairs, Item smallBricksStairs, Item bricksSlab, Item tilesSlab, Item smallBricksSlab, Item runicBricks, Item runicTiles, Item runicSmallBricks, Item runicBricksStairs, Item runicTilesStairs, Item runicSmallBricksStairs, Item runicBricksSlab, Item runicTilesSlab, Item runicSmallBricksSlab, Item rockWall, Item smoothRockWall, Item polishedRockWall, Item bricksWall, Item tilesWall, Item smallBricksWall, Item runicBricksWall, Item runicTilesWall, Item runicSmallBricksWall, Item column, Item columnCap, Item cutRock, Item checkeredRock, Item chiseledRock, Item pressurePlate, Item button, Item itemStand, Item itemPedestal, TagKey<Item> setEncompassingTag, TagKey<Item> blockTag, TagKey<Item> stairTag, TagKey<Item> slabTag, TagKey<Item> wallTag) {
    }
}

