/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.datagen.recipe.builder;

import com.google.common.collect.Lists;
import com.sammy.malum.common.recipe.SoulBindingRecipe;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.core.systems.recipe.SpiritIngredient;
import com.sammy.malum.core.systems.registry.SpiritHolder;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import team.lodestar.lodestone.recipe.builder.LodestoneRecipeBuilder;

public class SoulBindingRecipeBuilder
implements LodestoneRecipeBuilder<SoulBindingRecipe> {
    private final SizedIngredient input;
    private final GeasEffectType geas;
    private final List<SpiritIngredient> spirits = Lists.newArrayList();
    private final List<SizedIngredient> extraIngredients = Lists.newArrayList();

    public SoulBindingRecipeBuilder(Ingredient input, Holder<GeasEffectType> geas) {
        this(new SizedIngredient(input, 1), geas);
    }

    public SoulBindingRecipeBuilder(SizedIngredient input, Holder<GeasEffectType> geas) {
        this.input = input;
        this.geas = (GeasEffectType)geas.value();
    }

    public SoulBindingRecipeBuilder(Ingredient input, int inputCount, Holder<GeasEffectType> geas) {
        this(new SizedIngredient(input, inputCount), geas);
    }

    public SoulBindingRecipeBuilder(Item input, int inputCount, Holder<GeasEffectType> geas) {
        this(SizedIngredient.of((ItemLike)input, (int)inputCount), geas);
    }

    public SoulBindingRecipeBuilder addExtraItem(SizedIngredient ingredient) {
        this.extraIngredients.add(ingredient);
        return this;
    }

    public SoulBindingRecipeBuilder addExtraItem(Item input, int amount) {
        this.extraIngredients.add(SizedIngredient.of((ItemLike)input, (int)amount));
        return this;
    }

    public SoulBindingRecipeBuilder addExtraItem(TagKey<Item> input, int amount) {
        this.extraIngredients.add(SizedIngredient.of(input, (int)amount));
        return this;
    }

    public SoulBindingRecipeBuilder addSpirit(SpiritHolder<SpiritArcanaType> spirit, int count) {
        this.spirits.add(new SpiritIngredient((Holder<SpiritArcanaType>)spirit, count));
        return this;
    }

    public void save(RecipeOutput recipeOutput) {
        this.save(recipeOutput, this.geas.getRegistryName());
    }

    public SoulBindingRecipe buildRecipe(ResourceLocation id) {
        return new SoulBindingRecipe(this.input, this.geas, this.extraIngredients, this.spirits);
    }

    public String getRecipeSubfolder() {
        return "soul_binding";
    }
}

