/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.spirit.type;

import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import team.lodestar.lodestone.helpers.ColorHelper;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleDataBuilder;

public interface SpiritLike {
    @Nonnull
    public SpiritArcanaType getSpirit();

    default public boolean matches(SpiritLike other) {
        return this.getSpirit().equals(other.getSpirit());
    }

    default public String getFlavourKey() {
        return this.getLangKey() + ".flavour";
    }

    default public String getCountedKey() {
        return this.getLangKey() + ".counted";
    }

    default public String getLangKey() {
        return this.getRegistryName().getNamespace() + ".gui.spirit." + this.getName();
    }

    default public Holder<SpiritArcanaType> getHolder() {
        return (Holder)MalumSpiritTypes.SPIRIT_TYPES_REGISTRY.getHolder(this.getRegistryName()).orElseThrow();
    }

    default public ResourceLocation getRegistryName() {
        return MalumSpiritTypes.SPIRIT_TYPES_REGISTRY.getKey((Object)this.getSpirit());
    }

    default public String getName() {
        return this.getRegistryName().getPath();
    }

    default public int getAnalogSignal() {
        return Math.min(MalumSpiritTypes.SPIRIT_TYPES_REGISTRY.getId((Object)this.getSpirit()) + 1, 15);
    }

    default public SpiritShardItem getSpiritShard() {
        return this.getSpirit().getSpiritShard();
    }

    default public ItemStack getSpiritStack() {
        return this.getSpiritShard().getDefaultInstance();
    }

    default public ItemStack getSpiritStack(int count) {
        return new ItemStack((ItemLike)this.getSpiritShard(), count);
    }

    default public float getAlphaMultiplier() {
        return this.getSpirit().getColorProperties().alphaMultiplier();
    }

    default public Color getPrimaryColor() {
        return this.getSpirit().getColorProperties().primaryColor();
    }

    default public Color getSecondaryColor() {
        return this.getSpirit().getColorProperties().secondaryColor();
    }

    default public Color getItemColor() {
        return this.getSpirit().getColorProperties().itemColor();
    }

    default public ColorParticleDataBuilder createColorData() {
        return this.createColorData(1.0f);
    }

    default public ColorParticleDataBuilder createColorData(float coefficientMultiplier) {
        return this.getSpirit().getColorProperties().createColorData(coefficientMultiplier);
    }

    default public Style getStyle(boolean isTooltip) {
        return Style.EMPTY.withColor(this.getTextColor(isTooltip));
    }

    default public Style getStyle(float brightness) {
        return Style.EMPTY.withColor(this.getTextColor(brightness));
    }

    default public TextColor getTextColor(boolean isTooltip) {
        return this.getTextColor(isTooltip ? -0.75f : 0.85f);
    }

    default public TextColor getTextColor(float brightness) {
        Color color = this.getPrimaryColor();
        color = brightness < 0.0f ? ColorHelper.darker((Color)color, (int)1, (float)Mth.abs((float)brightness)) : ColorHelper.brighter((Color)color, (int)1, (float)brightness);
        return TextColor.fromRgb((int)color.getRGB());
    }
}

