/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.rite.effect;

import com.sammy.malum.core.systems.registry.SpiritHolder;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteEffectTag;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteEntityEffect;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.registry.common.MalumSoundEvents;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public abstract class SpiritRitePotionEffect<T extends LivingEntity>
extends SpiritRiteEntityEffect<T> {
    protected final Holder<MobEffect> effectType;
    protected final List<SpiritHolder<SpiritArcanaType>> spirits;

    @SafeVarargs
    public SpiritRitePotionEffect(Holder<MobEffect> effectType, SpiritHolder<SpiritArcanaType> ... spirits) {
        this(List.of(SpiritRiteEffectTag.LESSER_RITE, SpiritRiteEffectTag.AURA), effectType, spirits);
    }

    @SafeVarargs
    public SpiritRitePotionEffect(List<SpiritRiteEffectTag> tags, Holder<MobEffect> effectType, SpiritHolder<SpiritArcanaType> ... spirits) {
        super(tags);
        this.effectType = effectType;
        this.spirits = Arrays.asList(spirits);
    }

    public void applyRuneEffect(ServerLevel level, LivingEntity target) {
        if (this.getTargetClass().isInstance(target)) {
            this.applyEffect(level, target, 600, 0);
        }
    }

    @Override
    public boolean canApplyEffect(ServerLevel level, T target) {
        MobEffectInstance effect = target.getEffect(this.effectType);
        if (effect != null) {
            return effect.getDuration() < 200;
        }
        return super.canApplyEffect(level, target);
    }

    @Override
    public void applyEffect(ServerLevel level, T target) {
        this.applyEffect(level, target, 3000, 1);
    }

    public final void applyEffect(ServerLevel level, T target, int duration, int amplifier) {
        MobEffectInstance instance = new MobEffectInstance(this.effectType, duration, amplifier, true, true);
        if (this.canApplyEffect(level, target)) {
            this.createEffect(level, target, this.spirits);
        }
        target.addEffect(instance);
    }

    @Override
    public Holder<SoundEvent> getImpactSound() {
        return MalumSoundEvents.SPARK_POTION_IMPACT;
    }

    @Override
    public float getImpactSoundVolume(LivingEntity target) {
        return target instanceof Player ? 0.8f : 0.4f;
    }

    public Holder<MobEffect> getEffect() {
        return this.effectType;
    }
}

