/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.rite;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.sammy.malum.common.block.curiosities.totem.TotemBaseBlockEntity;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.registry.SpiritHolder;
import com.sammy.malum.core.systems.registry.rite.RiteEffectHolder;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteEffect;
import com.sammy.malum.core.systems.rite.effect.SpiritRiteEffectTag;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.registry.common.magic.rite.MalumSpiritRiteTypes;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;

public class SpiritRiteType {
    public static final Codec<Holder<SpiritRiteType>> HOLDER_CODEC = MalumSpiritRiteTypes.RITE_REGISTRY.holderByNameCodec();
    public static final Codec<SpiritRiteType> CODEC = MalumSpiritRiteTypes.RITE_REGISTRY.byNameCodec();
    public static StreamCodec<ByteBuf, SpiritRiteType> STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);
    protected final List<SpiritHolder<SpiritArcanaType>> spirits;
    protected final boolean isCorrupted;
    protected final RiteEffectHolder<? extends SpiritRiteEffect> effect;
    private List<Component> detailedDescription;

    public SpiritRiteType(RiteEffectHolder<? extends SpiritRiteEffect> effect, boolean isCorrupted, List<SpiritHolder<SpiritArcanaType>> spirits) {
        this.effect = effect;
        this.isCorrupted = isCorrupted;
        this.spirits = spirits;
    }

    public List<SpiritHolder<SpiritArcanaType>> getSpirits() {
        return this.spirits;
    }

    public SpiritHolder<SpiritArcanaType> getIdentifyingSpirit() {
        return this.getSpirits().getLast();
    }

    public boolean isCorrupted() {
        return this.isCorrupted;
    }

    public SpiritRiteEffect getEffect() {
        return (SpiritRiteEffect)this.effect.get();
    }

    public void triggerRiteEffect(ServerLevel level, TotemBaseBlockEntity totemBase) {
        SpiritRiteEffect.RiteParameters params = SpiritRiteEffect.builder().setTotemHeight(totemBase.getTotemHeight()).setTotemDirection(totemBase.getTotemDirection()).build();
        this.getEffect().triggerRiteEffect(level, totemBase.getBlockPos(), (SpiritArcanaType)this.getIdentifyingSpirit().get(), params);
    }

    public boolean matches(ServerLevel level, TotemBaseBlockEntity totemBase) {
        List<SpiritArcanaType> totemSpirits = totemBase.getSpirits(level);
        if (totemBase.corrupted != this.isCorrupted) {
            return false;
        }
        if (totemSpirits.size() != this.spirits.size()) {
            return false;
        }
        for (int i = 0; i < totemSpirits.size(); ++i) {
            SpiritArcanaType totemSpirit;
            SpiritHolder<SpiritArcanaType> spirit = this.spirits.get(i);
            if (spirit.is(totemSpirit = totemSpirits.get(i))) continue;
            return false;
        }
        return true;
    }

    public List<Component> getDetailedDescription() {
        if (this.detailedDescription == null) {
            ArrayList<Object> tooltip = new ArrayList<Object>();
            Style color = this.getIdentifyingSpirit().getStyle(0.9f);
            MutableComponent title = Component.translatable((String)this.getLangKey()).withStyle(color);
            MutableComponent tags = this.getTags();
            List<Component> effectDetails = this.getEffectDetails();
            tooltip.add(title);
            tooltip.add(tags);
            tooltip.addAll(effectDetails);
            this.detailedDescription = ImmutableList.copyOf(tooltip);
        }
        return this.detailedDescription;
    }

    public List<Component> getEffectDetails() {
        MutableComponent effect = Component.translatable((String)this.getEffectLangKey());
        String text = effect.getString();
        String[] parts = text.split("\n");
        return Arrays.stream(parts).map(p -> ComponentHelper.riteEffect(p, this)).toList();
    }

    public MutableComponent getTags() {
        MutableComponent component = Component.empty();
        ArrayList<SpiritRiteEffectTag> tags = new ArrayList<SpiritRiteEffectTag>(this.getEffect().getTags());
        tags.addFirst(this.isCorrupted() ? SpiritRiteEffectTag.SOULWOOD : SpiritRiteEffectTag.RUNEWOOD);
        Iterator iterator = tags.iterator();
        while (iterator.hasNext()) {
            SpiritRiteEffectTag tag = (SpiritRiteEffectTag)iterator.next();
            component.append((Component)Component.translatable((String)tag.getLangKey()));
            if (!iterator.hasNext()) continue;
            component.append((Component)Component.literal((String)", "));
        }
        return component.withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.DARK_GRAY});
    }

    public ResourceLocation getRegistryName() {
        return MalumSpiritRiteTypes.RITE_REGISTRY.getKey((Object)this);
    }

    public String getLangKey() {
        return this.getRegistryName().getNamespace() + ".gui.rite." + this.getName();
    }

    public String getEffectLangKey() {
        return this.getLangKey() + ".effect";
    }

    public String getCodexEntryLangKey() {
        return "malum.gui.book.entry.page.text." + this.getName();
    }

    public String getName() {
        return this.getRegistryName().getPath();
    }

    public ResourceLocation getIcon() {
        return this.getRegistryName().withPath(s -> "textures/vfx/rite/" + s).withSuffix(".png");
    }

    public final void save(CompoundTag tag) {
        this.save(tag, "rite");
    }

    public final void save(CompoundTag tag, String name) {
        tag.put(name, (Tag)CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this).getOrThrow());
    }

    public static Optional<SpiritRiteType> load(CompoundTag tag) {
        return SpiritRiteType.load(tag, "rite");
    }

    public static Optional<SpiritRiteType> load(CompoundTag tag, String name) {
        return CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)tag.get(name)).map(Pair::getFirst).result();
    }
}

